﻿'*******************************************************************************
'With this program, commands are sent to and received from the connected instrument.
'To send a command, enter the command to be sent in the command field and press the [Send] button.
'For a command with a response (command that includes "?"), a response is displayed in the text field.
'*******************************************************************************

Public Class Form1
    Dim LanSocket As System.Net.Sockets.TcpClient                           'TCP client socket
    Dim MsgBuf As String = ""                                               'Receiving buffer
    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim ip As System.Net.IPAddress = New System.Net.IPAddress(0)        'IP address
        Dim port As Integer                                                 'Port number

        Try
            LanSocket = New System.Net.Sockets.TcpClient                    'Create TCP socket
            If Not (System.Net.IPAddress.TryParse(TextBox1.Text, ip)) Then
                MsgBox("Error. Plese check the IP address.")
                Exit Sub
            End If
            port = Convert.ToInt32(TextBox2.Text)
            LanSocket.Connect(ip, port)                                     'Connect
            LanSocket.NoDelay = True                                        'TcpNoDelay

            Button1.Enabled = False
            Button2.Enabled = True
            Button3.Enabled = True
            TextBox3.Enabled = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Try
            LanSocket.Close()                                               'Disconnect
            Button1.Enabled = True
            Button2.Enabled = False
            Button3.Enabled = False
            TextBox3.Enabled = False
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        If InStr(TextBox3.Text, "?") = 0 Then                               'If command does not include "?", only command sending is executed
            SendMsg(TextBox3.Text)                                          'Send message
            TextBox4.Text += "> " + TextBox3.Text + vbCrLf
        Else                                                                'If command includes "?", command sending and response receiving are executed
            SendQueryMsg(TextBox3.Text)                                     'Send message and Receive message
            TextBox4.Text += "> " + TextBox3.Text + vbCrLf
            TextBox4.Text += "< " + MsgBuf
        End If

    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        TextBox4.Text = Nothing                                             'Clear
    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Dim SendBuffer As Byte()
        Try
            strMsg = strMsg & vbCrLf
            SendBuffer = System.Text.Encoding.Default.GetBytes(strMsg)
            LanSocket.GetStream.Write(SendBuffer, 0, SendBuffer.Length)     'Send message
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Dim Length As Integer
        Dim ReceiveBuffer(1) As Byte

        LanSocket.GetStream.ReadTimeout = 120000                             'Timeout 120sec

        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                              'Wait until response is received
                'If LanSocket.GetStream.DataAvailable Then
                Length = LanSocket.GetStream.Read(ReceiveBuffer, 0, 1)
                Check = ReceiveBuffer(0)
                If Chr(Check) = vbLf Then
                    Exit Do
                ElseIf Chr(Check) = vbCr Then
                Else
                    MsgBuf = MsgBuf & Chr(Check)
                End If
                'End If
            Loop
            MsgBuf = MsgBuf & vbCrLf
        Catch Ex As Exception
            MsgBuf = vbCrLf
            MsgBox(Ex.Message)
        End Try
    End Sub

End Class

