
// SampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sample.h"
#include "SampleDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CSampleDlg dialog

CSampleDlg::CSampleDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSampleDlg::IDD, pParent)
	, m_dwIpAddress(0xC0A800FE)
	, m_nPort(1024)
	, m_strSend(_T(""))
	, m_strLog(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_IPAddress(pDX, IDC_IPADDRESS, m_dwIpAddress);
	DDX_Text(pDX, IDC_PORT_EDIT, m_nPort);
	DDX_Text(pDX, IDC_SEND_EDIT, m_strSend);
	DDX_Text(pDX, IDC_LOG_EDIT, m_strLog);
}

BEGIN_MESSAGE_MAP(CSampleDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_CONNECT_BTN, &CSampleDlg::OnBnClickedConnectBtn)
	ON_BN_CLICKED(IDC_DISCONNECT_BTN, &CSampleDlg::OnBnClickedDisconnectBtn)
	ON_BN_CLICKED(IDC_SEND_BTN, &CSampleDlg::OnBnClickedSendBtn)
	ON_BN_CLICKED(IDC_CLEAR_BTN, &CSampleDlg::OnBnClickedClearBtn)
END_MESSAGE_MAP()


// CSampleDlg message handlers

BOOL CSampleDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	GetDlgItem(IDC_SEND_EDIT)->EnableWindow(FALSE);			//Disable Send edit
	GetDlgItem(IDC_DISCONNECT_BTN)->EnableWindow(FALSE);	//Disable Disconnect button
	GetDlgItem(IDC_SEND_BTN)->EnableWindow(FALSE);			//Disable Send button

	//Initiate use of the Winsock 
	CMySocket::Init();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.
void CSampleDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

//The framework calls this member function to inform the CWnd object that it is being destroyed.
void CSampleDlg::OnDestroy()
{
	CDialogEx::OnDestroy();

	//Terminate use of the Winsock 
	CMySocket::Finish();
}

//Clicked Connect Button
void CSampleDlg::OnBnClickedConnectBtn()
{
	UpdateData(TRUE);

	if(m_mySocket.Connect(m_dwIpAddress, m_nPort)){
		//Succeeded
		GetDlgItem(IDC_SEND_EDIT)->EnableWindow(TRUE);		//Enable Send edit
		GetDlgItem(IDC_DISCONNECT_BTN)->EnableWindow(TRUE);	//Enable Disconnect button
		GetDlgItem(IDC_SEND_BTN)->EnableWindow(TRUE);		//Enable Send button
		GetDlgItem(IDC_CONNECT_BTN)->EnableWindow(FALSE);	//Disable Connect button
	}else{
		//Failed
		AfxMessageBox(_T("A connection failed."));
	}
}

//Clicked Disconnect Button
void CSampleDlg::OnBnClickedDisconnectBtn()
{
	m_mySocket.Disconnect();

	GetDlgItem(IDC_SEND_EDIT)->EnableWindow(FALSE);			//Disable Send edit
	GetDlgItem(IDC_DISCONNECT_BTN)->EnableWindow(FALSE);	//Disable Disconnect button
	GetDlgItem(IDC_SEND_BTN)->EnableWindow(FALSE);			//Disable Send button
	GetDlgItem(IDC_CONNECT_BTN)->EnableWindow(TRUE);		//Disable Connect button
}

//Clicked Send Button
void CSampleDlg::OnBnClickedSendBtn()
{

	UpdateData(TRUE);

	//Send
	if(!m_mySocket.Send(m_strSend)){ 
		AfxMessageBox(_T("Sending a command failed."));
		return; 
	}

	//Add send data in log.
	m_strLog += _T("> ");
	m_strLog += m_strSend;
	m_strLog += _T("\r\n");

	if(m_strSend.Find('?') > 0){	//Query command?
		CString strRet = _T("");

		//Receive
		strRet = m_mySocket.Receive();
		if(strRet == _T("")){
			AfxMessageBox(_T("Receiving a response failed."));
		}else{
			//Add receive data in log.
			m_strLog += _T("< ");
			m_strLog += strRet;
			m_strLog += _T("\r\n");
		}
	}

	UpdateData(FALSE);
}

//Clicked Clear Button
void CSampleDlg::OnBnClickedClearBtn()
{
	m_strLog = _T("");
	UpdateData(FALSE);
}
