#include "StdAfx.h"
#include "MySocket.h"

#define CODE_CR	(0x0d)
#define CODE_LF	(0x0a)

BOOL CMySocket::m_bInit = FALSE;

CMySocket::CMySocket(void)
{
	m_Socket = INVALID_SOCKET;
}


CMySocket::~CMySocket(void)
{

}

//Initiate use of the Winsock 
/*********************************
 Execute only once in a project.
*********************************/
//static
BOOL CMySocket::Init()
{
	WORD wVersionRequested;
	WSADATA wsaData;
	BOOL bErr = FALSE;
	wVersionRequested = MAKEWORD( 2, 2 );		//Version 2.2

	//The WSAStartup function initiates use of the Winsock DLL by a process.
	if(WSAStartup(wVersionRequested, &wsaData) == 0){
		//Succeeded
		CMySocket::m_bInit = TRUE;
	}else{
		//Failed
		AfxMessageBox(_T("Initializing LAN communications failed."));
		return FALSE;
	}

	return TRUE;
}

//Terminate use of the Winsock 
//static
void CMySocket::Finish()	
{
	if(CMySocket::m_bInit){
		//The WSACleanup function terminates use of the Winsock 2 DLL.
		WSACleanup();
		CMySocket::m_bInit = FALSE;
	}
}

//Connect
BOOL CMySocket::Connect(DWORD dwIp, int nPort)
{
	char strIp[128];
	struct sockaddr_in dstAddr;

	//Create socket
	m_Socket = socket(AF_INET, SOCK_STREAM, 0);
	if(m_Socket == INVALID_SOCKET){
		AfxMessageBox(_T("A connection failed."));
		return FALSE;
	}

	//Create the connection settings 
	sprintf_s(strIp, 128, "%d.%d.%d.%d", (UCHAR)(dwIp >> 24), 
										 (UCHAR)(dwIp >> 16), 
										 (UCHAR)(dwIp >> 8), 
										 (UCHAR)(dwIp));
	memset(&dstAddr, 0, sizeof(dstAddr));
	dstAddr.sin_port	= htons((USHORT)nPort);
	dstAddr.sin_family	= AF_INET;
	dstAddr.sin_addr.S_un.S_addr = inet_addr(strIp);

	//Connect
	if(connect(m_Socket, (sockaddr *)&dstAddr, sizeof(dstAddr)) == SOCKET_ERROR)
    {
		//Failed
		return FALSE;

	}else{
		//Succeeded

		//TcpNoDelay setting
		BOOL opt = 1;
		setsockopt(m_Socket, IPPROTO_TCP, TCP_NODELAY, (char*)&opt, sizeof(BOOL));

		//Receive timeout setting
		DWORD dwTimeout = 120000;	//120sec
		setsockopt(m_Socket, SOL_SOCKET, SO_RCVTIMEO, (char *)&dwTimeout, sizeof(DWORD));
	}

	return TRUE;
}

//Disconnect
void CMySocket::Disconnect()
{
	if(m_Socket != INVALID_SOCKET){
		//Close
		shutdown(m_Socket, SD_BOTH);
		closesocket(m_Socket);
	}
}

//Send
#define SND_BUF_SIZE (512)
BOOL CMySocket::Send(CString strSend)
{
	char send_buff[SND_BUF_SIZE + 2];

	int size = strSend.GetLength();

	//Check size
	if(size >= SND_BUF_SIZE){ 
		AfxMessageBox(_T("Command is too long."));
		return FALSE;
	}

	//Create send data.
	memcpy(send_buff, strSend.GetBuffer(), size);
	send_buff[size]	  = CODE_CR;	//Add Cr
	send_buff[size+1] = CODE_LF;	//Add Lf

	//Send
	int send_size = send(m_Socket, send_buff, size + 2, 0);

	if(send_size != size + 2){
		//Failed
		return FALSE;
	}

	return TRUE;
}

//Receive
#define RCV_BUF_SIZE (4*1024)
CString CMySocket::Receive()
{
	CString strRet = _T("");
	char rcv_buff[RCV_BUF_SIZE];

	//Receive
	int rcv_count = recv(m_Socket, rcv_buff, RCV_BUF_SIZE, 0);

	if(rcv_count <= 0){
		//Timeout
		goto end;
	}
	else if(rcv_buff[rcv_count - 1] == CODE_LF){	//Is the last charactor Lf?
		//Suceeded
		rcv_buff[rcv_count - 2] = 0x00;			//Make string  -->  Set the next of the last letter to 0x00.
		strRet = rcv_buff;

	}else{
		AfxMessageBox(_T("Response is too long."));
	}

end:
	return strRet;
}
