%% History 
%% V1.00 (Dec. 2023) : Release 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%
%% This sample is when Ch1 to CH3 are M7100 or U8550.
%%%%

%% Setting the commucation.
t = OpenTCP('192.168.1.2',8802);                % OpenTCP(str(IP address),int(port number)). 
                                                % Must match the logger settings.

%% Get target info.
ret = SendQuery(t, '*IDN?');
spl = strsplit(ret,',');
model = spl(2);
if strncmp(model, 'LR810', 5)
    resolution = 10 / 100000;                   % Resolution of 10V range(M7100).Refer manual.
    moduleStr = ':MODule';
    chType = 'int32';                           % Channel binary data type.
                                                % PLS1 'int32', LOG 'uint16', ALARM 'uint16', W1 to W30 'double' 
else
    resolution = 10 / 10000;                    % Resolution of 10V range(U8550).Refer manual.
    moduleStr = ':UNIT';
    chType = 'int16';                           % Channel binary data type.
                                                % PLS1 to PLS8 'int32', LOG 'uint16', ALARM 'uint16', W1 to W30 'double' 
end

%% Setting the logger.
SendCmd(t, '*RST');                             % Reset logger settings.
ret = SendQuery(t, '*OPC?');                    % Wait for reset to finish.
SendCmd(t, ':COMMent:TITLe "MATLAB Sample"');   % Set Title.
SendCmd(t, ':CONFigure:SAMPle 100E-3');         % Set sampling rate to 100ms.
SendCmd(t, [moduleStr,':RANGe CH1_1,10']);      % Set voltage range to 10V.
SendCmd(t, [moduleStr,':RANGe CH1_2,10']);      % Set voltage range to 10V.
SendCmd(t, [moduleStr,':RANGe CH1_3,10']);      % Set voltage range to 10V.
SendCmd(t, ':START');                           % Start mesuament.

rcvNum = 0;                                     % Number of received data.
maxDataNum = 100;                               % Number of data for 10 seconds.

%% Preparing for screen drawing.
figure;
ch1 = animatedline('Color', 'r');
ch2 = animatedline('Color', 'g');
ch3 = animatedline('Color', 'b');
axis([0 10 -10 10]);
times = linspace(0, 10, maxDataNum);

%% When using scaling,you need to refer to the scaling value for each channel.
%% Refer to the :SCALing command of the manual.
ratio = 1;                                      % Here ratio is fixed to 1.
offset = 0;                                     % Here offset is fixed to 0.

%% Repeat dta acquistion and drawing process.
buf = SendQuery(t, ':MEMORY:AMAXPOINT?');
top = str2double(buf);                          % Get data from current latest.
while(rcvNum <= maxDataNum)
    buf = SendQuery(t, ':MEMORY:AMAXPOINT?');
    MaxPoint = str2double(buf);
    stepNum = MaxPoint - top;

    %% If the data is progressing,data acquisition and drawing.
    if 0 < stepNum
        Wave = zeros(stepNum,3);
        
        %% Receive data at BDATa command.
        Wave(:,1) = GetWaveBDATa(t, 'CH1_1', chType, top, stepNum, resolution, ratio, offset);

        %% Receive data at ADATa command.
        Wave(:,2) = GetWaveADATa(t, 'CH1_2', top, stepNum, resolution, ratio, offset);

        %% Receive data at VDATa command.
        %% The value inludes scaling settings.
        Wave(:,3) = GetWaveVDATa(t, 'CH1_3', top, stepNum);              

        for k = 1: stepNum
            x = rcvNum + k;
            if x <= maxDataNum
                addpoints(ch1, times(x), Wave(k, 1));
                addpoints(ch2, times(x), Wave(k, 2));
                addpoints(ch3, times(x), Wave(k, 3));
            else
                break;
            end
        end
        drawnow;
        pause(500/1000);                 % 500ms wait. Please adjust as necessary.

        top = top + stepNum;
        rcvNum = rcvNum + stepNum;
    end
end

SendCmd(t, ':STOP;:STOP');               % Stop mesuament.
CloseTCP(t);