function WData = GetWaveVDATa(Client, CH, dataTop, dataNum)
    %% Receive data at VDATa command.

    %% Specify the starting position of the data acquisition point.
    topStr = num2str(dataTop);
    SendCmd(Client,[':MEMory:POINt ',CH,',',topStr]);

    bMax = 1000;                            % Maxinum numbe of data received at one time
    Data = zeros(1,dataNum);
    pos = 1;
    oddNum = dataNum;

    %% Receive remaining data
    while (oddNum ~= 0)
        getDataNum = min(oddNum, bMax);
        dataNumStr = num2str(getDataNum);
        ret = SendQuery(Client,[':MEMory:VDATa? ',dataNumStr]);
        spl = str2double(strsplit(ret,','));
       
        Data(pos : pos + getDataNum - 1) = spl(1:getDataNum);
        oddNum = oddNum - getDataNum;
        pos = pos + getDataNum;
    end
    
    WData = Data; 
end

