function WData = GetWaveBDATa(Client, CH, chType, dataTop, dataNum, resolution, ratio, offset)
    %% Receive data at BDATa command.

    %% Specify the starting position of the data acquisition point.
    topStr = num2str(dataTop);
    SendCmd(Client,[':MEMory:POINt ',CH,',',topStr]);

    MaxNum = 5000;                          % Maxinum numbe of data received at one time
    count = 0;
    Data = zeros(1,dataNum);
    pos = 1;
    oddNum = dataNum;

    %% Receive remaining data
    while (oddNum ~= 0)
        getDataNum = min(oddNum, MaxNum);
        dataNumStr = num2str(getDataNum);
        SendCmd(Client,[':MEMory:BDATa? ',dataNumStr])
        Head = read(Client, 2, 'int8'); 
        while ~strcmp(char(Head),'#0')
                count = count + 1;
                if count >= 100 
                    return;
                end
           Head = read(Client, 2, 'int8'); 
        end
       
        Data(pos : pos + getDataNum - 1) = swapbytes(read(Client, getDataNum, chType));
        oddNum = oddNum - getDataNum;
        pos = pos + getDataNum;
    end
    
    %% Convert to final value
    WData = Data.* resolution * ratio + offset;
end

