function WData = GetWaveADATa(Client, CH, dataTop, dataNum, resolution, ratio, offset)
    %% Receive data at ADATa command.

    %% Specify the starting position of the data acquisition point.
    topStr = num2str(dataTop);
    SendCmd(Client,[':MEMory:POINt ',CH,',',topStr]);

    MaxNum = 2000;                          % Maxinum numbe of data received at one time
    Data = zeros(1,dataNum);
    pos = 1;
    oddNum = dataNum;

    %% Receive remaining data
    while (oddNum ~= 0)
        getDataNum = min(oddNum, MaxNum);
        dataNumStr = num2str(getDataNum);
        ret = SendQuery(Client,[':MEMory:ADATa? ', dataNumStr]);
        spl = str2double(strsplit(ret, ','));
       
        Data(pos : pos + getDataNum - 1) = spl(1:getDataNum);
        oddNum = oddNum - getDataNum;
        pos = pos + getDataNum;
    end   
    
    %% Convert to final value
    WData = Data.* resolution * ratio + offset;   
end

