/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class WaveDataPW6001 {
    private int samplingSpeed = 0;
    private int storageLength = 0;
    private double convertRate = 0.0;
    private int storageMode = 0;
    private int logicCH = 0;
    private short[][] data = null;
    private boolean valid = false;

    public static String ver() {
        return "Ver.1.00";
    }

    public static void main(String[] args) {
        System.out.println(WaveDataPW6001.ver());
    }

    public int getSamplingSpeed() {
        return this.samplingSpeed;
    }

    public int getStorageLength() {
        return this.storageLength;
    }

    public double getConvertRate() {
        return this.convertRate;
    }

    public int getStorageMode() {
        return this.storageMode;
    }

    public int getLogicCH() {
        return this.logicCH;
    }

    boolean getValid() {
        return this.valid;
    }

    public short[] getMaxData() {
        return this.data[0];
    }

    public short[] getMinData() {
        return this.data[1];
    }

    public void setData(byte[] aData) {
        if (null == aData) {
            return;
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(aData));
        try {
            this.samplingSpeed = dis.readInt();
            this.storageLength = dis.readInt();
            this.convertRate = dis.readDouble();
            this.storageMode = dis.readInt();
            this.logicCH = dis.readInt();
            this.data = new short[2][this.storageLength];
            for (int idx = 0; idx < this.storageLength; ++idx) {
                this.data[0][idx] = dis.readShort();
                this.data[1][idx] = dis.readShort();
            }
            this.valid = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

