/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;

public class TcpipPW6001 {
    private Socket sock = null;
    private BufferedWriter os = null;
    private BufferedReader tis = null;
    private BufferedInputStream bis = null;
    private String addr = null;
    private int portNum = 0;
    private int timeoutLength = 10000;

    public static String ver() {
        return "Ver.1.00";
    }

    public static void main(String[] args) {
        System.out.println(TcpipPW6001.ver());
    }

    public TcpipPW6001(String anAddr, int aPort) {
        this.addr = anAddr;
        this.portNum = aPort;
    }

    public boolean valid() {
        return null != this.sock && null != this.os && null != this.tis && null != this.bis;
    }

    public String ipAddr() {
        return this.addr;
    }

    public int port() {
        return this.portNum;
    }

    public int open() {
        try {
            this.sock = new Socket(InetAddress.getByName(this.addr), this.portNum);
            this.os = new BufferedWriter(new OutputStreamWriter(this.sock.getOutputStream()), 2000);
            this.tis = new BufferedReader(new InputStreamReader(this.sock.getInputStream()), 2000);
            this.bis = new BufferedInputStream(new DataInputStream(this.sock.getInputStream()), 2000);
            this.setTimeout(this.timeoutLength);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public int setTimeout(int aTimeoutLength) {
        if (!this.valid()) {
            this.timeoutLength = aTimeoutLength;
            return 0;
        }
        try {
            this.sock.setSoTimeout(aTimeoutLength);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        this.timeoutLength = aTimeoutLength;
        return 0;
    }

    public int getTimeout() {
        if (!this.valid()) {
            return this.timeoutLength;
        }
        try {
            return this.sock.getSoTimeout();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int close() {
        if (!this.valid()) {
            return 1;
        }
        try {
            this.os.close();
            this.tis.close();
            this.bis.close();
            this.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        this.os = null;
        this.tis = null;
        this.bis = null;
        this.sock = null;
        return 0;
    }

    public int send(String msg) {
        if (!this.valid()) {
            return 1;
        }
        try {
            this.os.write(msg + "\r\n");
            this.os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public String receive() {
        if (!this.valid()) {
            return null;
        }
        try {
            String receivedMsg = this.tis.readLine();
            if (this.bis.available() > 0) {
                this.bis.skip(this.bis.available());
            }
            return receivedMsg;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getWave(WaveDataPW6001 waveData, String msg) {
        if (!this.valid()) {
            return 0;
        }
        switch (msg) {
            case "U1": 
            case "U2": 
            case "U3": 
            case "U4": 
            case "U5": 
            case "U6": 
            case "I1": 
            case "I2": 
            case "I3": 
            case "I4": 
            case "I5": 
            case "I6": 
            case "A": 
            case "B": 
            case "LOGIC": {
                break;
            }
            default: {
                return 1;
            }
        }
        byte[] data = null;
        try {
            this.os.write(":DOWNload:WAVE2? " + msg + "\r\n");
            this.os.flush();
            byte[] dataSizeBin = new byte[11];
            this.bis.read(dataSizeBin);
            int dataSize = Integer.parseInt(new String(dataSizeBin));
            this.bis.skip(1L);
            if (dataSize > 0) {
                data = new byte[dataSize];
                int av = 0;
                while ((av += this.bis.read(data, av, dataSize - av)) < dataSize) {
                }
                if (this.bis.available() > 0) {
                    System.err.println("Error Byte " + this.bis.available() + "\r\n");
                }
            }
            waveData.setData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public int getFFT(FFTDataPW6001 fftData, String msg) {
        if (!this.valid()) {
            return 1;
        }
        switch (msg) {
            case "1": 
            case "2": {
                break;
            }
            default: {
                return 1;
            }
        }
        byte[] data = null;
        try {
            this.os.write(":DOWNload:FFT? " + msg + "\r\n");
            this.os.flush();
            byte[] dataSizeBin = new byte[11];
            this.bis.read(dataSizeBin);
            int dataSize = Integer.parseInt(new String(dataSizeBin));
            this.bis.skip(1L);
            if (dataSize > 0) {
                data = new byte[dataSize];
                int av = 0;
                while ((av += this.bis.read(data, av, dataSize - av)) < dataSize) {
                }
                if (this.bis.available() > 0) {
                    System.err.println("Error Byte" + this.bis.available() + "\r\n");
                }
            }
            fftData.setData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }
}

