/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class FFTDataPW6001 {
    private int samplingSpeed = 0;
    private int fftLength = 0;
    private float convertRate = 0.0f;
    private int fftCh = 0;
    private int fftValid = 0;
    private float[] data = null;

    public static String ver() {
        return "Ver.1.00";
    }

    public static void main(String[] args) {
        System.out.println(FFTDataPW6001.ver());
    }

    public int getSamplingSpeed() {
        return this.samplingSpeed;
    }

    public int getFFTLength() {
        return this.fftLength;
    }

    public float getConvertRate() {
        return this.convertRate;
    }

    public int getFFTCh() {
        return this.fftCh;
    }

    public int getFFTValid() {
        return this.fftValid;
    }

    public float[] getData() {
        return this.data;
    }

    public void setData(byte[] aData) {
        if (null == aData) {
            return;
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(aData));
        try {
            this.samplingSpeed = dis.readInt();
            this.fftLength = dis.readInt();
            this.convertRate = dis.readFloat();
            this.fftCh = dis.readInt();
            this.fftValid = dis.readInt();
            int dataLength = (int)((float)this.fftLength * 0.4f);
            this.data = new float[dataLength];
            for (int idx = 0; idx < dataLength; ++idx) {
                this.data[idx] = dis.readFloat();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

