function [cAnalogUsage cLogicUsage dTime dAnalog dLogic] = HiMemory(filename)

%---------------------------------------------------------------------------
%
% 	Loading driver for the 'Memory HiCORDERs'.
%
%	Ver 2.00
%
%	< Definition >
%	[cAnalogUsage cLogicUsage dTime dAnalog dLogic] = HiMemory(filename)
%
%	HiMemory(filename) is the driver used to load HIOKI MEMORY HiCORDER ".mem" files into MATLAB.
%
%	[Input Argument]
%		@filename
%			Specify the file name.
%			(Example:) data.mem
%
%	[Output Argument]
%		@cAnalogUsage (char array)
%			Displays the save status of the analog channels.
%			The returned value 0 or 1 represents the save status of each channel,
%			such that 1 represents saved and 0 represents not saved.
%			The left-most value of the returned value represents CH1, with each subsequent value
%			to the right representing the next higher order channel.
%			
%			(Response Example:)	1100000000000000
%				CH1 = Stored
%				CH2 = Stored
%				CH3 and beyond = Not stored (no data)
%
%		@cLogicUsage (char array)
%			Displays the save status of the logic channels.
%			The returned value 0 or 1 represents the save status of each channel,
%			such that 1 represents saved and 0 represents not saved.
%			The left-most value of the returned value represents CHA, with each subsequent value
%			to the right representing the next higher order channel.
%
%			(Response Example:)	1100
%				CHA (CHA-1) to (CHA-4) = Stored
%				CHB (CHB-1) to (CHB-4) = Stored
%				CHC (CHC-1) to (CHC-4) = Not stored (no data)
%				CHD (CHD-1) to (CHD-4) = Not stored (no data)
%
%		@dTime (double array)
%			Displays the time axis data.
%
%		@dAnalog (double array)
%			Stores the data for the analog channels in sequence. 
%			Data saved as @cAnalogUsage will be stored in order.
%			Channels not saved will be compressed.
%			When extracting the first data, specify dAnalog(:, 1).
%
%		@dLogic (uint8 array)
%			Stores the logic channel data in sequence. 
%			Data saved as @cLogicUsage will be stored in order.
%			One logic channel is composed of 4 data.
%			As such, the sequence will be 4 times the single number representing cLogicUsage.
%			When @cLogicUsage is 1100, data from CHA-1 to CHB-4 is stored in @dLogic.
%			Channels not saved will be compressed.
%			When extracting the first data, specify dLogic(:, 1).
%
%
%	HiMemory(filename) is the driver used to load HIOKI MEMORY HiCORDER ".mem" files into MATLAB.
%	Compatible MEMORY HiCORDERs and limitations are indicated below.
%
%	1. Compatible MEMORY HiCORDERs
%		8835-01			(Ver. 1.03 or later)
%		9540-01			(Ver. 5.03 or later)
%		8841, 8842		(Ver. 2.31 or later)
%		8826			(Ver. 2.30 or later)
%		8847			(Ver. 2.05 or later)
%
%	2. Supported Function
%		MEM (MEMORY Function)
%
%	3. Supported MATLAB Version
%		MATLAB R2006b Version	7.3.0.267 (R2006b)
%
%	4. Compatible Operating Systems
%		WindowsXPsp3 or later (32bit)
%
%	5. Copyright
%		The copyright of this driver software and related documents belong to HIOKI E.E.CORPORATION.
%		Sales of this software or bundling with any other document without permission by copyright holder are prohibited. 
%		Also, any modification of this software without permission by copyright holder is strictly prohibited.
%
%	6. Responsibility of Use
%		The programs provided here are all freeware. 
%		HIOKI E.E. Corporation disclaims all responsibility for any losses arising out of use of the software provided herein, as well as for any programming errors or problems arising out of use of the software.
%		The software is provided on an "as is" basis, and HIOKI cannot respond to any inquiries concerning the software.
%
%---------------------------------------------------------------------------

[cAnalogUsage cLogicUsage dTime dAnalog dLogic] = HiMemory(filename);
