
Public Class Form1


    Dim MsgBuf As String


    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        '*******************************************************************************
        ' USB SAMPLE PROGRAM NO.2
        '
        ' This command connects to LR8410,LR8416 and do the acquisition of measurement data.  
		'*Using the :MEMORY:MAXPOINT? query, this program checks whether
		'data can be output from memory. If this query returns zero,
		'no data is stored, and it cannot therefore be output.
		'*Next, the program specifies the channel and point for output,
		'using the :MEMORY:POINT command. As data is input or output,
		'the point is incremented automatically. If capturing data
		'consecutively, it is sufficient to specify the point once only.
		'*To capture data in ASCII format use the :MEMORY:ADATA? query,
		'and to capture data as voltage values use the :MEMORY:VDATA? query.
		'The number of data samples which may be output in one set is
		'1 to 80 using :ADATA? and 1 to 40 using the :VDATA? query.
		'*Outputting data in bigger sets reduces the overall processing time.
		'*Read data (100+1 samples) for channel 1 when stored with
		'a 10ms interval and 1sec recording time.
        '*******************************************************************************

        Dim data As Double
        Dim i As Integer

        SendMsgCrLf(":CONFIGURE:SAMPLE 100.0E-3")              'LR8410,LR8416,Sampling 100ms
        SendMsgCrLf(":CONFIGURE:RECTIME 0,0,0,10")             'LR8410,LR8416,Recording time 10s
        SendMsgCrLf(":UNIT:STORE CH1_1,ON")                    'CH1_1 is store
        SendMsgCrLf(":TRIGGER:MODE SINGLE")                    'Repeatedly record is OFF 
        GetMsgCrLf(":START;:STOP;*OPC?")                       'Start

        SendMsgCrLf(":HEADER OFF")                             'Header OFF
        GetMsgCrLf(":MEMORY:MAXPOINT?")                        'Get Storege data Num.
        If (Val(MsgBuf) = 0) Then
            Exit Sub
        End If

        SendMsgCrLf(":MEMORY:POINT CH1_1,0")                   'Set output Point CH1_1,0
        For i = 0 To 100
            GetMsgCrLf(":MEMORY:VDATA? 1")
            data = Val(MsgBuf)
            TextBox1.SelectedText = Format(data, "Scientific") & vbCrLf
        Next

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click

        SerialPort1.PortName = TextCom.Text                    'port set
        SerialPort1.Open()                                     'connect

        TextBox2.Text = "USB connect"

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        SerialPort1.Close()                                    'dis connect

        TextBox2.Text = "USB dis connect"

    End Sub

    Private Sub SendMsgCrLf(ByVal strMsg As String)

        strMsg = strMsg & vbCrLf
        SerialPort1.WriteLine(strMsg)                          'send mesage

    End Sub

    Private Sub GetMsgCrLf(ByVal strMsg As String)

        strMsg = strMsg & vbCrLf
        SerialPort1.WriteLine(strMsg)                          'send message

        Dim Check As Integer
        MsgBuf = Nothing
        Do                                                     'wait for receive
            Check = SerialPort1.ReadByte()
            If Chr(Check) = vbLf Then
                Exit Do
            ElseIf Chr(Check) = vbCr Then
            Else
                MsgBuf = MsgBuf & Chr(Check)
            End If
        Loop

    End Sub

End Class
