
Public Class Form1

    Const OUT_PIPE As Integer = 1                                      'USB Send PIPE No.
    Const IN_PIPE As Integer = 0                                       'USB Receive PIPE No.
    Const USB_RECEIVE_MAX As Integer = 512

    Dim OutDeviceHandle As Integer                             'USB Send Handle
    Dim InDeviceHandle As Integer                              'USB Receive Handle

    '    Module1.bas
    '    Declare Function CloseHandle Lib "KERNEL32" (ByVal hFile As Integer) As Integer
    '    Declare Function OpenUSBBulkFile Lib "HiUsbL.dll" (ByVal pipeNo As Integer, ByVal ProductID As Integer, ByVal SN As Integer) As Integer
    '    Declare Function ReadUSBBulk Lib "HiUsbL.dll" (ByVal hFile As Integer, ByRef lpBuffer As Byte, ByVal nNumberOfBytesToRead As Integer, ByRef lpNumberOfBytesRead As Integer) As Integer
    '    Declare Function WriteUSBBulk Lib "HiUsbL.dll" (ByVal hFile As Integer, ByVal lpBuffer As String, ByVal nNumberOfBytesToWrite As Integer, ByRef lpNumberOfBytesWritten As Integer) As Integer
    '    Module1.bas


    Dim MsgBuf As String


    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        '*******************************************************************************
        ' LAN SAMPLE PROGRAM NO.1
        '
        ' This program connects to 8423 and do the sending and receiving of a command.  
        ' When push a command execute button and input the command 
        ' that wants to transmit it to the column of a command it is transmitted.  
        ' The answer is displayed to a text box, in the case of the command that is included (? ).  
        '*******************************************************************************

        If InStr(TextBox3.Text, "?") = 0 Then                   '

            SendMsgCrLf(TextBox3.Text)                          'Send command
            TextBox1.Text = ""

        Else                                                    '

            GetMsgCrLf(TextBox3.Text)                           'Send command and receive query
            TextBox1.Text = MsgBuf

        End If

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click

        OutDeviceHandle = OpenUSBBulkFile(OUT_PIPE, CInt(Val("8423")), CInt(Val(TextSerial.Text)))
        InDeviceHandle = OpenUSBBulkFile(IN_PIPE, CInt(Val("8423")), CInt(Val(TextSerial.Text)))

        TextBox2.Text = "USB connect"

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        CloseHandle(OutDeviceHandle)
        CloseHandle(InDeviceHandle)

        TextBox2.Text = "USB dis connect"

    End Sub

    Private Sub SendMsgCrLf(ByVal strMsg As String)

        Dim sendCount As Integer
        Dim ans As Integer

        strMsg = strMsg & vbCrLf
        ans = WriteUSBBulk(OutDeviceHandle, strMsg, Len(strMsg), sendCount)            'send message

    End Sub

    Private Sub GetMsgCrLf(ByVal strMsg As String)

        Dim sendCount As Integer
        Dim recvCount As Integer
        Dim ans As Integer
        Dim recvBuff(USB_RECEIVE_MAX * 2) As Byte
        Dim i As Integer
        Dim c As Integer

        strMsg = strMsg & vbCrLf
        ans = WriteUSBBulk(OutDeviceHandle, strMsg, Len(strMsg), sendCount)            'send message

        ans = ReadUSBBulk(InDeviceHandle, recvBuff(0), USB_RECEIVE_MAX, recvCount)           'receive message

        MsgBuf = ""
        For i = 0 To recvCount - 1
            c = recvBuff(i)
            If c > &H1F Then
                MsgBuf = MsgBuf + Chr(c)
            ElseIf Chr(c) = vbCr Then
                Exit For
            End If
        Next

    End Sub

End Class
