﻿Imports System.Net                      'TcpClientのために定義
Imports System.Net.Sockets              'TcpClientのために定義
Imports System.Text                     'Encodingのために定義


Public Class Form1


    Dim netStream As NetworkStream


    Dim MsgBuf As String


    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        '*******************************************************************************
        ' LAN SAMPLE PROGRAM NO.2
        '
        'このコマンドは、本器に接続して測定データの取得を行います。
        ' ・:MEMORY:MAXPOINT?ｸｴﾘによって、ｽﾄﾚｰｼﾞﾃﾞｰﾀが入出力可能であるか調べます。
        '    ｽﾄﾚｰｼﾞされていない状態では、MAXPOINT?による出力値が0となり、ﾃﾞｰﾀの出力
        '    はできません。
        ' ・出力したいﾃﾞｰﾀのﾁｬﾈﾙとﾎﾟｲﾝﾄを:MEMORY:POINTｺﾏﾝﾄﾞによって指定します。
        '    ﾃﾞｰﾀを入出力すると自動的にﾎﾟｲﾝﾄが移動していきます。連続したﾃﾞｰﾀを取込
        '    む場合には、一度指定するだけで済みます。
        ' ・ASCII形式で取込む場合は、:MEMORY:ADATA?ｸｴﾘ、電圧値形式の場合は:VDATA?
        '    ｸｴﾘを使用します。まとめて出力できるﾃﾞｰﾀ数は:ADATA?で1～80個、:VDATA?
        '    で1～40個ですがﾊﾞｯﾌｧの容量により、個数制限されます。
        ' ・より多くのﾃﾞｰﾀをまとめて出力させるほど、処理全体の時間は短くなります。
        ' ・ﾃﾞｰﾀ間隔10ms、記録長1秒でｽﾄﾚｰｼﾞされているﾃﾞｰﾀのCH1_1のﾃﾞｰﾀ100+1個を取り込みます。
        '*******************************************************************************

        Dim data As Double
        Dim i As Integer

        SendMsgCrLf(":CONFIGURE:SAMPLE 50.0E-3")               'ﾃﾞｰﾀ間隔50msに設定
        SendMsgCrLf(":CONFIGURE:RECTIME 0,0,0,5")              '記録長5秒に設定
        SendMsgCrLf(":UNIT:STORE CH1_1,ON")                    'CH1_1を収集に設定
        SendMsgCrLf(":TRIGGER:MODE SINGLE")                    'ﾄﾘｶﾞをSINGLEに設定(繰り返しOFF)
        GetMsgCrLf(":START;:STOP;*OPC?")                       'ｽﾀｰﾄ処理
        '注記
        '":START;:STOP;*OPC?"とすることによって、指定記録長分
        'の取り込みを終了の待つことができます。
        '１度のSTOPキーでは、記録長分の取り込みが終わるまで
        '取り込みを中断しないためです。

        SendMsgCrLf(":HEADER OFF")                             'ﾍｯﾀﾞをOFF
        GetMsgCrLf(":MEMORY:MAXPOINT?")                        'ｽﾄﾚｰｼﾞﾃﾞｰﾀ数を読み出す
        If (Val(MsgBuf) = 0) Then
            Exit Sub
        End If

        SendMsgCrLf(":MEMORY:POINT CH1_1,0")                   '出力ﾃﾞｰﾀをCH1_1、ﾎﾟｲﾝﾄ0に設定
        For i = 0 To 100
            GetMsgCrLf(":MEMORY:VDATA? 1")
            data = Val(MsgBuf)
            TextBox1.SelectedText = Format(data, "Scientific") & vbCrLf
        Next

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click

        Dim client As New TcpClient(TextIp.Text, Val(TextPort.Text))    'IPとポートを指定してTCP接続を定義

        netStream = client.GetStream()                     'LANでTCPの送受信に使用するnetStreamをオープン
        netStream.WriteTimeout = 100000
        netStream.ReadTimeout = 100000

        'Do While (Winsock1.State <> sckConnected)
        '    If Winsock1.State = sckConnecting Then Text2.Text = "LAN接続待ち"
        '    DoEvents()
        'Loop
        'If Winsock1.State = sckConnected Then Text2.Text = "LAN接続完了"

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        netStream.Close()                                  'LANでTCPの送受信に使用するnetStreamをクローズ

        'Do While (Winsock1.State <> sckClosed)
        '    If Winsock1.State = sckConnected Then Text2.Text = "LAN切断待ち"
        '    DoEvents()
        'Loop
        'If Winsock1.State = sckClosed Then Text2.Text = "LAN切断完了"

    End Sub

    Private Sub SendMsgCrLf(ByVal strMsg As String)

        strMsg = strMsg & vbCrLf
        netStream.Write(Encoding.ASCII.GetBytes(strMsg), 0, strMsg.Length)            'ﾒｯｾｰｼﾞ送信

    End Sub

    Private Sub GetMsgCrLf(ByVal strMsg As String)
        Dim Check As Integer

        strMsg = strMsg & vbCrLf
        netStream.Write(Encoding.ASCII.GetBytes(strMsg), 0, strMsg.Length)            'ﾒｯｾｰｼﾞ送信

        MsgBuf = Nothing
        Do                                                    '応答受信まで待つ
            Check = netStream.ReadByte()

            If Chr(Check) = vbLf Then
                '                MsgBuf = MsgBuf & Chr(Check)
                Exit Do
            ElseIf Chr(Check) = vbCr Then
                '                MsgBuf = MsgBuf & Chr(Check)
            Else
                MsgBuf = MsgBuf & Chr(Check)
            End If
        Loop
        MsgBuf = MsgBuf & vbCrLf

    End Sub

    Private Sub TextIp_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextIp.TextChanged

    End Sub
End Class
