﻿
Public Class Form1


    Dim MsgBuf As String


    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        '*******************************************************************************
        ' LAN SAMPLE PROGRAM NO.2
        ' ｽﾄﾚｰｼﾞﾃﾞｰﾀの出力法
        '
        ' ・:MEMORY:MAXPOINT?ｸｴﾘによって、ｽﾄﾚｰｼﾞﾃﾞｰﾀが入出力可能であるか調べます。
        ' ｽﾄﾚｰｼﾞされていない状態では、MAXPOINT?による出力値が0となり、ﾃﾞｰﾀの出力
        ' はできません。
        ' ・出力したいﾃﾞｰﾀのﾁｬﾈﾙとﾎﾟｲﾝﾄを:MEMORY:POINTｺﾏﾝﾄﾞによって指定します。
        ' ﾃﾞｰﾀを入出力すると自動的にﾎﾟｲﾝﾄが移動していきます。連続したﾃﾞｰﾀを取込
        ' む場合には、一度指定するだけで済みます。
        ' ・ASCII形式で取込む場合は、:MEMORY:ADATA?ｸｴﾘ、電圧値形式の場合は:VDATA?
        ' ｸｴﾘを使用します。まとめて出力できるﾃﾞｰﾀ数は:ADATA?で1～80個、:VDATA?
        ' で1～40個ですがﾊﾞｯﾌｧの容量により、個数制限されます。
        ' ・より多くのﾃﾞｰﾀをまとめて出力させるほど、処理全体の時間は短くなります。
        ' ・ﾃﾞｰﾀ間隔10ms、記録長1秒でｽﾄﾚｰｼﾞされているﾃﾞｰﾀのCH1_1のﾃﾞｰﾀ100+1個を取り込みます。
        '*******************************************************************************

        Dim data As Double
        Dim i As Integer

        SendMsgCrLf(":CONFIGURE:SAMPLE 50.0E-3")               'ﾃﾞｰﾀ間隔50msに設定
        SendMsgCrLf(":CONFIGURE:RECTIME 0,0,0,5")              '記録長5秒に設定
        SendMsgCrLf(":UNIT:STORE CH1_1,ON")                    'CH1_1を収集に設定
        SendMsgCrLf(":TRIGGER:MODE SINGLE")                    'ﾄﾘｶﾞをSINGLEに設定(繰り返しOFF)
        GetMsgCrLf(":START;:STOP;*OPC?")                       'ｽﾀｰﾄ処理
        '注記
        '":START;:STOP;*OPC?"とすることによって、指定記録長分
        'の取り込みを終了の待つことができます。
        '１度のSTOPキーでは、記録長分の取り込みが終わるまで
        '取り込みを中断しないためです。

        SendMsgCrLf(":HEADER OFF")                             'ﾍｯﾀﾞをOFF
        GetMsgCrLf(":MEMORY:MAXPOINT?")                        'ｽﾄﾚｰｼﾞﾃﾞｰﾀ数を読み出す
        If (Val(MsgBuf) = 0) Then
            Exit Sub
        End If

        SendMsgCrLf(":MEMORY:POINT CH1_1,0")                   '出力ﾃﾞｰﾀをCH1_1、ﾎﾟｲﾝﾄ0に設定
        For i = 0 To 100
            GetMsgCrLf(":MEMORY:VDATA? 1")
            data = Val(MsgBuf)
            TextBox1.SelectedText = Format(data, "Scientific") & vbCrLf
        Next

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click

        SerialPort1.PortName = TextCom.Text                    'ポートを指定
        SerialPort1.Open()                                     '接続

        TextBox2.Text = "USB接続完了"

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        SerialPort1.Close()                                    '切断

        TextBox2.Text = "USB切断完了"

    End Sub

    Private Sub SendMsgCrLf(ByVal strMsg As String)

        strMsg = strMsg & vbCrLf
        SerialPort1.WriteLine(strMsg)                          'ﾒｯｾｰｼﾞ送信

    End Sub

    Private Sub GetMsgCrLf(ByVal strMsg As String)

        strMsg = strMsg & vbCrLf
        SerialPort1.WriteLine(strMsg)                          'ﾒｯｾｰｼﾞ送信

        Dim Check As Integer
        MsgBuf = Nothing
        Do                                                     '応答受信まで待つ
            Check = SerialPort1.ReadByte()
            If Chr(Check) = vbLf Then
                Exit Do
            ElseIf Chr(Check) = vbCr Then
            Else
                MsgBuf = MsgBuf & Chr(Check)
            End If
        Loop

    End Sub

    Private Sub TextCom_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextCom.TextChanged

    End Sub
End Class
