
Public Class Form1

    Const OUT_PIPE As Integer = 1                                      'USB Send PIPE No.
    Const IN_PIPE As Integer = 0                                       'USB Receive PIPE No.
    Const USB_RECEIVE_MAX As Integer = 512

    Dim OutDeviceHandle As Integer                             'USB Send Handle
    Dim InDeviceHandle As Integer                              'USB Receive Handle

    '    Module1.bas
    '    Declare Function CloseHandle Lib "KERNEL32" (ByVal hFile As Integer) As Integer
    '    Declare Function OpenUSBBulkFile Lib "HiUsbL.dll" (ByVal pipeNo As Integer, ByVal ProductID As Integer, ByVal SN As Integer) As Integer
    '    Declare Function ReadUSBBulk Lib "HiUsbL.dll" (ByVal hFile As Integer, ByRef lpBuffer As Byte, ByVal nNumberOfBytesToRead As Integer, ByRef lpNumberOfBytesRead As Integer) As Integer
    '    Declare Function WriteUSBBulk Lib "HiUsbL.dll" (ByVal hFile As Integer, ByVal lpBuffer As String, ByVal nNumberOfBytesToWrite As Integer, ByRef lpNumberOfBytesWritten As Integer) As Integer
    '    Module1.bas


    Dim MsgBuf As String


    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        '*******************************************************************************
        ' LAN SAMPLE PROGRAM NO.2
        '
        ' This command connects to 8423 and do the acquisition of measurement data.  
		'*Using the :MEMORY:MAXPOINT? query, this program checks whether
		'data can be output from memory. If this query returns zero,
		'no data is stored, and it cannot therefore be output.
		'*Next, the program specifies the channel and point for output,
		'using the :MEMORY:POINT command. As data is input or output,
		'the point is incremented automatically. If capturing data
		'consecutively, it is sufficient to specify the point once only.
		'*To capture data in ASCII format use the :MEMORY:ADATA? query,
		'and to capture data as voltage values use the :MEMORY:VDATA? query.
		'The number of data samples which may be output in one set is
		'1 to 80 using :ADATA? and 1 to 40 using the :VDATA? query.
		'*Outputting data in bigger sets reduces the overall processing time.
		'*Read data (100+1 samples) for channel 1 when stored with
		'a 10ms interval and 1sec recording time.
        '*******************************************************************************

        Dim data As Double
        Dim i As Integer

        SendMsgCrLf(":CONFIGURE:SAMPLE 10.0E-3")               'Sampling 10ms
        SendMsgCrLf(":CONFIGURE:RECTIME 0,0,0,1")              'Recording time 1s
        SendMsgCrLf(":UNIT:STORE UNIT1,CH1,ON")                'UNIT1,CH1 is store
        SendMsgCrLf(":TRIGGER:MODE SINGLE")                    'Repeatedly record is OFF 
        GetMsgCrLf(":START;:STOP;*OPC?")                       'Start

        SendMsgCrLf(":HEADER OFF")                             'Header OFF
        GetMsgCrLf(":MEMORY:MAXPOINT?")                        'Get Storege data Num.
        If (Val(MsgBuf) = 0) Then
            Exit Sub
        End If

        SendMsgCrLf(":MEMORY:POINT UNIT1,CH1,0")               'Set output Point UNIT1,CH1,0
        For i = 0 To 100
            GetMsgCrLf(":MEMORY:VDATA? 1")
            data = Val(MsgBuf)
            TextBox1.SelectedText = Format(data, "Scientific") & vbCrLf
        Next

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click

        OutDeviceHandle = OpenUSBBulkFile(OUT_PIPE, CInt(Val("8423")), CInt(Val(TextSerial.Text)))
        InDeviceHandle = OpenUSBBulkFile(IN_PIPE, CInt(Val("8423")), CInt(Val(TextSerial.Text)))

        TextBox2.Text = "USB connect"

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        CloseHandle(OutDeviceHandle)
        CloseHandle(InDeviceHandle)

        TextBox2.Text = "USB dis connect"

    End Sub

    Private Sub SendMsgCrLf(ByVal strMsg As String)

        Dim sendCount As Integer
        Dim ans As Integer

        strMsg = strMsg & vbCrLf
        ans = WriteUSBBulk(OutDeviceHandle, strMsg, Len(strMsg), sendCount)            'send message

    End Sub

    Private Sub GetMsgCrLf(ByVal strMsg As String)

        Dim sendCount As Integer
        Dim recvCount As Integer
        Dim ans As Integer
        Dim recvBuff(USB_RECEIVE_MAX * 2) As Byte
        Dim i As Integer
        Dim c As Integer

        strMsg = strMsg & vbCrLf
        ans = WriteUSBBulk(OutDeviceHandle, strMsg, Len(strMsg), sendCount)            'send message

        ans = ReadUSBBulk(InDeviceHandle, recvBuff(0), USB_RECEIVE_MAX, recvCount)           'receive message

        MsgBuf = ""
        For i = 0 To recvCount - 1
            c = recvBuff(i)
            If c > &H1F Then
                MsgBuf = MsgBuf + Chr(c)
            ElseIf Chr(c) = vbCr Then
                Exit For
            End If
        Next

    End Sub

End Class
