Imports System.Net                      'TcpClient
Imports System.Net.Sockets              'TcpClient
Imports System.Text                     'Encoding


Public Class Form1


    Dim netStream As NetworkStream


    Dim MsgBuf As String


    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        '*******************************************************************************
        ' LAN SAMPLE PROGRAM NO.2
        '
        'This command connects to LR8400 and do the acquisition of measurement data.  
	    '*Using the :MEMORY:MAXPOINT? query, this program checks whether
	    'data can be output from memory. If this query returns zero,
	    'no data is stored, and it cannot therefore be output.
	    '*Next, the program specifies the channel and point for output,
	    'using the :MEMORY:POINT command. As data is input or output,
	    'the point is incremented automatically. If capturing data
	    'consecutively, it is sufficient to specify the point once only.
	    '*To capture data in ASCII format use the :MEMORY:ADATA? query,
	    'and to capture data as voltage values use the :MEMORY:VDATA? query.
	    'The number of data samples which may be output in one set is
	    '1 to 80 using :ADATA? and 1 to 40 using the :VDATA? query.
	    '*Outputting data in bigger sets reduces the overall processing time.
	    '*Read data (100+1 samples) for channel 1 when stored with
	    'a 10ms interval and 1sec recording time.
        '*******************************************************************************

        Dim data As Double
        Dim i As Integer

        SendMsgCrLf(":CONFIGURE:SAMPLE 50.0E-3")               'Sampling 50ms
        SendMsgCrLf(":CONFIGURE:RECTIME 0,0,0,5")              'Recording time 5s
        SendMsgCrLf(":UNIT:STORE CH1_1,ON")                    'CH1_1 is store
        SendMsgCrLf(":TRIGGER:MODE SINGLE")                    'Repeatedly record is OFF 
        GetMsgCrLf(":START;:STOP;*OPC?")                       'Start

        SendMsgCrLf(":HEADER OFF")                             'Header OFF
        GetMsgCrLf(":MEMORY:MAXPOINT?")                        'Get Storege data Num.
        If (Val(MsgBuf) = 0) Then
            Exit Sub
        End If

        SendMsgCrLf(":MEMORY:POINT CH1_1,0")                   'Set output Point CH1_1,0
        For i = 0 To 100
            GetMsgCrLf(":MEMORY:VDATA? 1")
            data = Val(MsgBuf)
            TextBox1.SelectedText = Format(data, "Scientific") & vbCrLf
        Next

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click

        Dim client As New TcpClient(TextIp.Text, Val(TextPort.Text))    'Set Tcp Client

        netStream = client.GetStream()                     'Open Tcp Client
        netStream.WriteTimeout = 100000
        netStream.ReadTimeout = 100000

        'Do While (Winsock1.State <> sckConnected)
        '    If Winsock1.State = sckConnecting Then Text2.Text = "connecting"
        '    DoEvents()
        'Loop
        'If Winsock1.State = sckConnected Then Text2.Text = "LAN connect"

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        netStream.Close()                                  'Close Tcp Client

        'Do While (Winsock1.State <> sckClosed)
        '    If Winsock1.State = sckConnected Then Text2.Text = "disconecting"
        '    DoEvents()
        'Loop
        'If Winsock1.State = sckClosed Then Text2.Text = "LAN disconnect"

    End Sub

    Private Sub SendMsgCrLf(ByVal strMsg As String)

        strMsg = strMsg & vbCrLf
        netStream.Write(Encoding.ASCII.GetBytes(strMsg), 0, strMsg.Length)            'send message

    End Sub

    Private Sub GetMsgCrLf(ByVal strMsg As String)
        Dim Check As Integer

        strMsg = strMsg & vbCrLf
        netStream.Write(Encoding.ASCII.GetBytes(strMsg), 0, strMsg.Length)            'send message

        MsgBuf = Nothing
        Do                                                    'wait receive command
            Check = netStream.ReadByte()

            If Chr(Check) = vbLf Then
                '                MsgBuf = MsgBuf & Chr(Check)
                Exit Do
            ElseIf Chr(Check) = vbCr Then
                '                MsgBuf = MsgBuf & Chr(Check)
            Else
                MsgBuf = MsgBuf & Chr(Check)
            End If
        Loop
        MsgBuf = MsgBuf & vbCrLf

    End Sub

End Class
