'*******************************************************************************
' LAN SAMPLE PROGRAM NO.2
'
'This command connects to 8847 and do the acquisition of measurement data.  
'*Using the :MEMORY:MAXPOINT? query, this program checks whether
'data can be output from memory. If this query returns zero,
'no data is stored, and it cannot therefore be output.
'*Next, the program specifies the channel and point for output,
'using the :MEMORY:POINT command. As data is input or output,
'the point is incremented automatically. If capturing data
'consecutively, it is sufficient to specify the point once only.
'*To capture data in ASCII format use the :MEMORY:ADATA? query,
'and to capture data as voltage values use the :MEMORY:VDATA? query.
'The number of data samples which may be output in one set is
'1 to 80 using :ADATA? and 1 to 80 using the :VDATA? query.
'*Outputting data in bigger sets reduces the overall processing time.
'*Read data (100+1 samples) for channel 1.
'*******************************************************************************
Imports System.Text
Public Class Form1
    Dim MsgBuf As String
    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Try
            SerialPort1.PortName = TextBox1.Text                        'Set Port
            SerialPort1.Open()                                        'Connect
            Button1.Enabled = False
            Button2.Enabled = True
            Button3.Enabled = True
            TextBox2.Enabled = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub
    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Try
            SerialPort1.Close()                                 'Disconnect
            Button1.Enabled = True
            Button2.Enabled = False
            Button3.Enabled = False
            TextBox2.Enabled = False
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        SendMsg(":HEADER OFF") 'Header OFF
        SendMsg(":FUNCTION MEM")
        SendMsg(":CONFIGURE:SHOT 100")
        SendMsg(":CONFIGURE:TDIV 5E-3")
        SendMsg(":TRIGGER:MODE SINGLE")
        SendMsg(":START") 'Start

        SendQueryMsg(":STOP;*OPC?")
        SendQueryMsg(":MEMORY:MAXPOINT?")              'Get Storege data Num.

        TextBox2.Text = ""

        If MsgBuf.Equals("0") Then
            TextBox2.Text = "No data"
            Return
        End If


        SendMsg(":MEMORY:POINT CH1,0")           'Set output Point CH1,0

        Dim I As Integer
        Dim Data As Double

        For I = 0 To 100
            SendQueryMsg(":MEMORY:VDATA? 1")
            Data = Val(MsgBuf)
            TextBox2.SelectedText = Format(Data, "Scientific") & vbCrLf
        Next I

    End Sub
    Private Sub SendMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            SerialPort1.WriteLine(strMsg)          'Send command
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            SerialPort1.WriteLine(strMsg)         'Send command
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                   'Wait receive command
                Check = SerialPort1.ReadByte()
                If Chr(Check) = vbLf Then
                    Exit Do
                ElseIf Chr(Check) = vbCr Then
                Else
                    MsgBuf = MsgBuf & Chr(Check)
                End If
            Loop
            MsgBuf = MsgBuf & vbCrLf
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub
End Class
