Public Class Form1
    Dim MsgBuf As String
    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Try
            SerialPort1.PortName = TextBox1.Text                           'Set Port
            SerialPort1.Open()                                           'Connect
            Button1.Enabled = False
            Button2.Enabled = True
            Button3.Enabled = True
            Button4.Enabled = True
            TextBox2.Enabled = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub
    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Try
            SerialPort1.Close()                              'Disconnect
            Button1.Enabled = True
            Button2.Enabled = False
            Button3.Enabled = False
            TextBox2.Enabled = False
            Button4.Enabled = False
            Timer1.Enabled = False
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub
    Private Sub SendMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            SerialPort1.WriteLine(strMsg)          'Send command
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            SerialPort1.WriteLine(strMsg)          'Send command
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                    'Wait receive query
                Check = SerialPort1.ReadByte()
                If Chr(Check) = vbLf Then
                    Exit Do
                ElseIf Chr(Check) = vbCr Then
                Else
                    MsgBuf = MsgBuf & Chr(Check)
                End If
            Loop
            MsgBuf = MsgBuf & vbCrLf
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub
    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        Timer1.Interval = 1000                              'Set interval
        Timer1.Enabled = True
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        stop_timer()
    End Sub
    Private Sub stop_timer()
        Timer1.Enabled = False
        TextBox2.SelectedText = "Stop"
    End Sub
    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick

        Dim data As Integer

        SendMsg(":HEADER OFF")
        SendQueryMsg(":STATUS?")

        data = Val(MsgBuf)

        If (data = 0) Then
            TextBox2.SelectedText = "Stopping" & vbCrLf
        End If

        If ((data And &H1) <> 0) Then                                                   ' bit0
            TextBox2.SelectedText = "Starting" & vbCrLf
        End If

        If ((data And &H2) <> 0) Then                                                   ' bit1
            TextBox2.SelectedText = "Storing" & vbCrLf
        End If

        If ((data And &H4) <> 0) Then                                                   ' bit2
            TextBox2.SelectedText = "Awaiting trigger" & vbCrLf
        End If

        If ((data And &H8) <> 0) Then                                                   ' bit3
            TextBox2.SelectedText = "Pre-trigger wait period" & vbCrLf
        End If

        If ((data And &H10) <> 0) Then                                                  ' bit4
            TextBox2.SelectedText = "Acquiring a waveform" & vbCrLf
        End If

        If ((data And &H20) <> 0) Then                                                  ' bit5
            TextBox2.SelectedText = "Saving" & vbCrLf
        End If

        If ((data And &H40) <> 0) Then                                                  ' bit6
            TextBox2.SelectedText = "Printing" & vbCrLf
        End If


    End Sub

    Private Sub TextBox2_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox2.TextChanged

    End Sub

    Private Sub TextBox1_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox1.TextChanged

    End Sub

    Private Sub Label2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label2.Click

    End Sub
End Class
