package test;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.security.AccessControlException;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JavaSample1 extends JFrame {

	private static final long serialVersionUID = 1L;

	final String Port = "8802";
	private String host = "192.168.0.2";

	// Panel
	JPanel Center = new JPanel();
	JPanel mid = new JPanel();

	// Label
	JLabel l_host = new JLabel("IP address");
	JLabel l_port = new JLabel("Port");

	// TextField
	JTextField t_host = new JTextField();
	JTextField t_port = new JTextField();

	// TextArea
	JTextArea t_message = new JTextArea(5, 10);
	JScrollPane scr_pane = new JScrollPane(t_message);

	// Button
	JButton b_start = new JButton("Measure");
	JButton b_stop = new JButton("Stop");

	public static void main(String args[]) {
		JavaSample1 test = new JavaSample1("8847");
		test.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		test.setSize(250, 320);
		test.setLocationRelativeTo(null);
		test.setVisible(true);
	}

	public JavaSample1(String title) {

		setTitle(title);

		Center.setLayout(new GridBagLayout());
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(5, 10, 5, 10);

		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 0.2d;
		gbc.weighty = 1.5d;
		Center.add(l_host, gbc);

		gbc.gridx = 0;
		gbc.gridy = 1;
		gbc.weightx = 0.2d;
		gbc.weighty = 1.5d;
		Center.add(l_port, gbc);

		gbc.gridx = 1;
		gbc.gridy = 0;
		gbc.weightx = 0.8d;
		gbc.weighty = 1.5d;
		Center.add(t_host, gbc);
		t_host.setText(host);

		gbc.gridx = 1;
		gbc.gridy = 1;
		gbc.weightx = 0.8d;
		gbc.weighty = 1.5d;
		Center.add(t_port, gbc);
		t_port.setText(Port);
		t_port.setEditable(false);

		gbc.gridx = 0;
		gbc.gridy = 2;
		gbc.weighty = 1d;
		gbc.gridwidth = 2;
		Center.add(mid, gbc);

		GridLayout layout_mid = new GridLayout(1, 2);
		layout_mid.setHgap(10);
		mid.setLayout(layout_mid);
		mid.add(b_start);
		mid.add(b_stop);

		gbc.gridx = 0;
		gbc.gridy = 3;
		gbc.weighty = 7d;
		gbc.gridwidth = 2;
		Center.add(scr_pane, gbc);
		t_message.setEditable(false);
		t_message.setLineWrap(true);

		this.add(Center);

		b_start.addActionListener(new ActionListener() { // Pressing the Measure button
					public void actionPerformed(ActionEvent arg0) {
						do_Action(":START");
					}
				});
		b_stop.addActionListener(new ActionListener() { // Pressing the Stop button
					public void actionPerformed(ActionEvent arg0) {
						do_Action(":ABORT");
					}
				});
	}
	
	private void do_Action(String message) {
		Socket socket = null;
		try {
			String host = t_host.getText();
			
			if (host.equals("")) {
				JOptionPane.showMessageDialog(this, "Please input the host name .", "Warning",
						JOptionPane.WARNING_MESSAGE);
				return;
			}

			socket = new Socket(host, Integer.parseInt(Port)); // Connect
			t_message.append("\nConnect" + socket.getRemoteSocketAddress() + "\n");
			
			PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
			out.println(message); 
			if (message.equals(":START")) {
				t_message.append("Start measuring\n");
			} else {
				t_message.append("Stop\n");
			}
			out.close();
		} catch (AccessControlException e) {
			JOptionPane.showMessageDialog(this, "Can't connect .\n Please confirm the communication setting .",
					"Error", JOptionPane.ERROR_MESSAGE);
		} catch (ConnectException e) {
			JOptionPane.showMessageDialog(this, "Can't connect .\n Please confirm the communication setting .",
					"Error", JOptionPane.ERROR_MESSAGE);
		} catch (IOException e) {
			JOptionPane.showMessageDialog(this, "Can't connect .\n Please confirm the communication setting .",
					"Error", JOptionPane.ERROR_MESSAGE);
		} finally {
			if (socket != null) {
				try {
					socket.close(); // Disconnect
					t_message.append("Disconnect\n");
				} catch (IOException e) {
					JOptionPane.showMessageDialog(this,
							"Disconnected.\nPlease confirm the communication setting .", "Error",
							JOptionPane.ERROR_MESSAGE);
				}
			}
		}
	}

}
