Public Class Form1
	Inherits System.Windows.Forms.Form

#Region " Windows"

	Public Sub New()
		MyBase.New()

		InitializeComponent()
		InitControlls()
	End Sub

	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub

	Private components As System.ComponentModel.IContainer

	Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
	Friend WithEvents BTN_CONNECT As System.Windows.Forms.Button
	Friend WithEvents BTN_DISCONNECT As System.Windows.Forms.Button
	Friend WithEvents Label6 As System.Windows.Forms.Label
	Friend WithEvents LIST_BOX_ADR As System.Windows.Forms.ListBox
	Friend WithEvents BTN_EXEC As System.Windows.Forms.Button
	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(Form1))
		Me.GroupBox1 = New System.Windows.Forms.GroupBox()
		Me.LIST_BOX_ADR = New System.Windows.Forms.ListBox()
		Me.BTN_CONNECT = New System.Windows.Forms.Button()
		Me.BTN_DISCONNECT = New System.Windows.Forms.Button()
		Me.Label6 = New System.Windows.Forms.Label()
		Me.BTN_EXEC = New System.Windows.Forms.Button()
		Me.GroupBox1.SuspendLayout()
		Me.SuspendLayout()
		'
		'GroupBox1
		'
		Me.GroupBox1.Controls.AddRange(New System.Windows.Forms.Control() {Me.LIST_BOX_ADR, Me.BTN_CONNECT, Me.BTN_DISCONNECT, Me.Label6, Me.BTN_EXEC})
		Me.GroupBox1.Location = New System.Drawing.Point(8, 8)
		Me.GroupBox1.Name = "GroupBox1"
		Me.GroupBox1.Size = New System.Drawing.Size(272, 96)
		Me.GroupBox1.TabIndex = 0
		Me.GroupBox1.TabStop = False
		Me.GroupBox1.Text = "GPIB"
		'
		'LIST_BOX_ADR
		'
		Me.LIST_BOX_ADR.Font = New System.Drawing.Font("MS UI Gothic", 11.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(128, Byte))
		Me.LIST_BOX_ADR.ItemHeight = 15
		Me.LIST_BOX_ADR.Items.AddRange(New Object() {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"})
		Me.LIST_BOX_ADR.Location = New System.Drawing.Point(88, 16)
		Me.LIST_BOX_ADR.Name = "LIST_BOX_ADR"
		Me.LIST_BOX_ADR.Size = New System.Drawing.Size(80, 19)
		Me.LIST_BOX_ADR.TabIndex = 1
		'
		'BTN_CONNECT
		'
		Me.BTN_CONNECT.Location = New System.Drawing.Point(176, 16)
		Me.BTN_CONNECT.Name = "BTN_CONNECT"
		Me.BTN_CONNECT.Size = New System.Drawing.Size(80, 20)
		Me.BTN_CONNECT.TabIndex = 4
		Me.BTN_CONNECT.Text = "Connect"
		'
		'BTN_DISCONNECT
		'
		Me.BTN_DISCONNECT.Enabled = False
		Me.BTN_DISCONNECT.Location = New System.Drawing.Point(176, 40)
		Me.BTN_DISCONNECT.Name = "BTN_DISCONNECT"
		Me.BTN_DISCONNECT.Size = New System.Drawing.Size(80, 20)
		Me.BTN_DISCONNECT.TabIndex = 5
		Me.BTN_DISCONNECT.Text = "Disconnect"
		'
		'Label6
		'
		Me.Label6.Location = New System.Drawing.Point(16, 16)
		Me.Label6.Name = "Label6"
		Me.Label6.Size = New System.Drawing.Size(72, 16)
		Me.Label6.TabIndex = 0
		Me.Label6.Text = "Address"
		'
		'BTN_EXEC
		'
		Me.BTN_EXEC.Enabled = False
		Me.BTN_EXEC.Location = New System.Drawing.Point(176, 64)
		Me.BTN_EXEC.Name = "BTN_EXEC"
		Me.BTN_EXEC.Size = New System.Drawing.Size(80, 20)
		Me.BTN_EXEC.TabIndex = 1
		Me.BTN_EXEC.Text = "Execute"
		'
		'Form1
		'
		Me.AutoScale = False
		Me.AutoScaleBaseSize = New System.Drawing.Size(5, 12)
		Me.ClientSize = New System.Drawing.Size(290, 111)
		Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.GroupBox1})
		Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
		Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
		Me.MaximizeBox = False
		Me.MinimizeBox = False
		Me.Name = "Form1"
		Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
		Me.Text = "Sample 03"
		Me.GroupBox1.ResumeLayout(False)
		Me.ResumeLayout(False)

	End Sub

#End Region

#Region "User"
	const g_MyAddress = 0

	Private Sub InitControlls()
		LIST_BOX_ADR.SelectedIndex = 5
	End Sub

	Function InitGpibParam() as Boolean

		If AXU2GPIBAX.gp_init(g_MyAddress, 0, 0) <> 0 Then
			return False
		End	If

		If AXU2GPIBAX.gp_cli() <> 0 Then
			return False
		End	If

		If AXU2GPIBAX.gp_ren() <> 0 Then
			return False
		End	If

		Dim strAddress as String = Str(LIST_BOX_ADR.TopIndex)
		If AXU2GPIBAX.gp_clr(strAddress) <> 0 Then
			return False
		End	If

		If AXU2GPIBAX.gp_llo() <> 0 Then
			return False
		End	If

		AXU2GPIBAX.gp_delm("b", &H080A)

		return True
	End Function

	Function FinalizeGpib() as Boolean
		AXU2GPIBAX.gp_lcl("")
		return True
	End Function


	Private Sub BTN_CONNECT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CONNECT.Click

		BTN_CONNECT.Enabled      = False
		BTN_DISCONNECT.Enabled   = True
		BTN_EXEC.Enabled         = True
		LIST_BOX_ADR.Enabled     = False

		if(InitGpibParam() = False) then
			FinalizeGpib()
		End If
	End Sub


	Private Sub CloseComm()
		BTN_CONNECT.Enabled      = True
		BTN_DISCONNECT.Enabled   = False
		BTN_EXEC.Enabled         = False
		LIST_BOX_ADR.Enabled     = True

		FinalizeGpib()
	End Sub


	Protected Overrides Sub OnClosing(ByVal e As System.ComponentModel.CancelEventArgs)
		CloseComm()
	End Sub

	Private Sub BTN_DISCONNECT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_DISCONNECT.Click
		CloseComm()
	End Sub

	Private Function SendMsg(ByRef strMsg As String) as Boolean
		Dim strAddress	As String  = Str(LIST_BOX_ADR.TopIndex)
		If(AXU2GPIBAX.gp_wrt(strAddress, strMsg) <> 0) Then
			MsgBox("Data send Failed")
			CloseComm()
			return False
		End If

		Return True

	End function

	Private Function ReciveMsg() As String
		const nBufSize			As Integer = 512
		Dim strMsg				As String = ""
		Dim bData(nBufSize)		As Byte
		Dim strAddress			As String = Str(LIST_BOX_ADR.TopIndex)

		if(AXU2GPIBAX.gp_red(strAddress, bData(0), nBufSize) <> 0)
			MsgBox("Data receive Failed")
			CloseComm()
			Return strMsg
		End If

		Dim i as Integer = 0
		for i = 0 to nBufSize - 1
			strMsg = strMsg & Chr(bData(i))
		Next i

		return strMsg
	End Function

    Private Function QueryMsg(ByRef strMsg As String) as String
		Dim strTemp	as String = ""

		if(SendMsg(strMsg) = True) then
            strTemp = ReciveMsg()
		End If

		return strTemp
    End Function

	Private Sub ExecuteCommands()
		Dim strMsg	as string  = ""
		Dim i		as Integer = 0
		Dim dData	as Double  = 0

		BTN_DISCONNECT.Enabled = False
		BTN_EXEC.Enabled       = False

        SendMsg(":HEADER OFF")
        SendMsg(":FUNCTION MEM")
        SendMsg(":CONFIGURE:SHOT 25")

		strMsg = QueryMsg(":MEMORY:PREPARE;*OPC?")
		if(strMsg = "") then
			Exit Sub
		End If

		SendMsg(":MEMORY:POINT CH1_1,0")

		Dim nBreak = 0

        For i = 0 To 2500
            SendMsg(":MEMORY:ADATA " & Str(Int(10000 * System.Math.Sin(3.14 * i / 200))))
			Application.DoEvents()
        Next

		BTN_DISCONNECT.Enabled = True
		BTN_EXEC.Enabled       = True
	End Sub

	Private Sub BTN_EXEC_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_EXEC.Click
		ExecuteCommands()
	End Sub
#End Region
End Class