Public Class Form1
	Inherits System.Windows.Forms.Form

#Region " Windows"

	Public Sub New()
		MyBase.New()

		InitializeComponent()
		InitControlls()
	End Sub

	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub

	Private components As System.ComponentModel.IContainer

	Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
	Friend WithEvents BTN_CONNECT As System.Windows.Forms.Button
	Friend WithEvents BTN_DISCONNECT As System.Windows.Forms.Button
	Friend WithEvents TextBox_Out As System.Windows.Forms.TextBox
	Friend WithEvents Label6 As System.Windows.Forms.Label
	Friend WithEvents LIST_BOX_ADR As System.Windows.Forms.ListBox
	Friend WithEvents BTN_EXEC As System.Windows.Forms.Button
	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(Form1))
		Me.GroupBox1 = New System.Windows.Forms.GroupBox()
		Me.LIST_BOX_ADR = New System.Windows.Forms.ListBox()
		Me.BTN_CONNECT = New System.Windows.Forms.Button()
		Me.BTN_DISCONNECT = New System.Windows.Forms.Button()
		Me.Label6 = New System.Windows.Forms.Label()
		Me.BTN_EXEC = New System.Windows.Forms.Button()
		Me.TextBox_Out = New System.Windows.Forms.TextBox()
		Me.GroupBox1.SuspendLayout()
		Me.SuspendLayout()
		'
		'GroupBox1
		'
		Me.GroupBox1.Controls.AddRange(New System.Windows.Forms.Control() {Me.LIST_BOX_ADR, Me.BTN_CONNECT, Me.BTN_DISCONNECT, Me.Label6})
		Me.GroupBox1.Location = New System.Drawing.Point(8, 8)
		Me.GroupBox1.Name = "GroupBox1"
		Me.GroupBox1.Size = New System.Drawing.Size(272, 72)
		Me.GroupBox1.TabIndex = 0
		Me.GroupBox1.TabStop = False
		Me.GroupBox1.Text = "GPIB"
		'
		'LIST_BOX_ADR
		'
		Me.LIST_BOX_ADR.Font = New System.Drawing.Font("MS UI Gothic", 11.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(128, Byte))
		Me.LIST_BOX_ADR.ItemHeight = 15
		Me.LIST_BOX_ADR.Items.AddRange(New Object() {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"})
		Me.LIST_BOX_ADR.Location = New System.Drawing.Point(88, 16)
		Me.LIST_BOX_ADR.Name = "LIST_BOX_ADR"
		Me.LIST_BOX_ADR.Size = New System.Drawing.Size(80, 19)
		Me.LIST_BOX_ADR.TabIndex = 1
		'
		'BTN_CONNECT
		'
		Me.BTN_CONNECT.Location = New System.Drawing.Point(176, 16)
		Me.BTN_CONNECT.Name = "BTN_CONNECT"
		Me.BTN_CONNECT.Size = New System.Drawing.Size(80, 20)
		Me.BTN_CONNECT.TabIndex = 4
		Me.BTN_CONNECT.Text = "Connect"
		'
		'BTN_DISCONNECT
		'
		Me.BTN_DISCONNECT.Enabled = False
		Me.BTN_DISCONNECT.Location = New System.Drawing.Point(176, 40)
		Me.BTN_DISCONNECT.Name = "BTN_DISCONNECT"
		Me.BTN_DISCONNECT.Size = New System.Drawing.Size(80, 20)
		Me.BTN_DISCONNECT.TabIndex = 5
		Me.BTN_DISCONNECT.Text = "Disconnect"
		'
		'Label6
		'
		Me.Label6.Location = New System.Drawing.Point(16, 16)
		Me.Label6.Name = "Label6"
		Me.Label6.Size = New System.Drawing.Size(72, 16)
		Me.Label6.TabIndex = 0
		Me.Label6.Text = "Address"
		'
		'BTN_EXEC
		'
		Me.BTN_EXEC.Enabled = False
		Me.BTN_EXEC.Location = New System.Drawing.Point(184, 88)
		Me.BTN_EXEC.Name = "BTN_EXEC"
		Me.BTN_EXEC.Size = New System.Drawing.Size(80, 20)
		Me.BTN_EXEC.TabIndex = 1
		Me.BTN_EXEC.Text = "Execute"
		'
		'TextBox_Out
		'
		Me.TextBox_Out.Enabled = False
		Me.TextBox_Out.Location = New System.Drawing.Point(8, 88)
		Me.TextBox_Out.Multiline = True
		Me.TextBox_Out.Name = "TextBox_Out"
		Me.TextBox_Out.ReadOnly = True
		Me.TextBox_Out.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
		Me.TextBox_Out.Size = New System.Drawing.Size(168, 216)
		Me.TextBox_Out.TabIndex = 4
		Me.TextBox_Out.Text = ""
		'
		'Form1
		'
		Me.AutoScale = False
		Me.AutoScaleBaseSize = New System.Drawing.Size(5, 12)
		Me.ClientSize = New System.Drawing.Size(290, 319)
		Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.GroupBox1, Me.TextBox_Out, Me.BTN_EXEC})
		Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
		Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
		Me.MaximizeBox = False
		Me.MinimizeBox = False
		Me.Name = "Form1"
		Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
		Me.Text = "Sample 02"
		Me.GroupBox1.ResumeLayout(False)
		Me.ResumeLayout(False)

	End Sub

#End Region

#Region "User"
	const g_MyAddress = 0

	Private Sub InitControlls()
		LIST_BOX_ADR.SelectedIndex = 5
	End Sub

	Function InitGpibParam() as Boolean

		If AXU2GPIBAX.gp_init(g_MyAddress, 0, 0) <> 0 Then
			return False
		End	If

		If AXU2GPIBAX.gp_cli() <> 0 Then
			return False
		End	If

		If AXU2GPIBAX.gp_ren() <> 0 Then
			return False
		End	If

		Dim strAddress as String = Str(LIST_BOX_ADR.TopIndex)
		If AXU2GPIBAX.gp_clr(strAddress) <> 0 Then
			return False
		End	If

		If AXU2GPIBAX.gp_llo() <> 0 Then
			return False
		End	If

		AXU2GPIBAX.gp_delm("b", &H080A)

		return True
	End Function

	Function FinalizeGpib() as Boolean
		AXU2GPIBAX.gp_lcl("")
		return True
	End Function

	Private Sub BTN_CONNECT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CONNECT.Click
		BTN_CONNECT.Enabled      = False
		BTN_DISCONNECT.Enabled   = True
		BTN_EXEC.Enabled         = True
		LIST_BOX_ADR.Enabled     = False
		TextBox_Out.Enabled      = True

		if(InitGpibParam() = False) then
			FinalizeGpib()
		End If
	End Sub

	Private Sub CloseComm()
		BTN_CONNECT.Enabled      = True
		BTN_DISCONNECT.Enabled   = False
		BTN_EXEC.Enabled         = False
		LIST_BOX_ADR.Enabled     = True
		TextBox_Out.Enabled      = False

		FinalizeGpib()
	End Sub

	Private Sub BTN_DISCONNECT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_DISCONNECT.Click
		CloseComm()
	End Sub

	Protected Overrides Sub OnClosing(ByVal e As System.ComponentModel.CancelEventArgs)
		CloseComm()
	End Sub

	Private Function SendMsg(ByRef strMsg As String) as Boolean
		Dim strAddress	As String  = Str(LIST_BOX_ADR.TopIndex)
		If(AXU2GPIBAX.gp_wrt(strAddress, strMsg) <> 0) Then
			MsgBox("Data send Failed")
			CloseComm()
			return False
		End If

		Return True

	End function

	Private Function ReciveMsg() As String
		const nBufSize			As Integer = 512
		Dim strMsg				As String = ""
		Dim bData(nBufSize)		As Byte
		Dim strAddress			As String = Str(LIST_BOX_ADR.TopIndex)

		if(AXU2GPIBAX.gp_red(strAddress, bData(0), nBufSize) <> 0)
			MsgBox("Data receive Failed")
			CloseComm()
			Return strMsg
		End If

		Dim i as Integer = 0
		for i = 0 to nBufSize - 1
			strMsg = strMsg & Chr(bData(i))
		Next i

		return strMsg
	End Function

    Private Function QueryMsg(ByRef strMsg As String) as String
		Dim strTemp	as String = ""

		if(SendMsg(strMsg) = True) then
            strTemp = ReciveMsg()
		End If

		return strTemp
    End Function

	Private Sub ExecuteCommands()
		Dim strMsg	as string  = ""
		Dim i		as Integer = 0
		Dim dData	as Double  = 0

		BTN_DISCONNECT.Enabled = False
		BTN_EXEC.Enabled       = False
		TextBox_Out.Text       = ""

        SendMsg(":HEADER OFF")
        SendMsg(":FUNCTION MEM")
        SendMsg(":CONFIGURE:SHOT 25")
        SendMsg(":CONFIGURE:TDIV 1E-3")
        SendMsg(":TRIGGER:MODE SINGLE")
        SendMsg(":START")

        strMsg = QueryMsg(":STOP;*OPC?")
        strMsg = QueryMsg(":MEMORY:MAXPOINT?")
        If (Val(strMsg) = 0) Then
			BTN_DISCONNECT.Enabled = True
			BTN_EXEC.Enabled       = True
            Exit Sub
        End If

        SendMsg(":MEMORY:POINT CH1_1,0")
        For i = 0 To 100
            strMsg = QueryMsg(":MEMORY:VDATA? 1")
            dData  = Val(strMsg)
            TextBox_Out.SelectedText = Format(dData, "0.00000E+00")	+vbCrLf
        Next i

		BTN_DISCONNECT.Enabled = True
		BTN_EXEC.Enabled       = True
	End Sub

	Private Sub BTN_EXEC_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_EXEC.Click
		ExecuteCommands()
	End Sub
#End Region
End Class