/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.security.AccessControlException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JavaSample1
extends JFrame {
    private static final long serialVersionUID = 1L;
    final String Port = "8802";
    private String host = "192.168.0.2";
    JPanel Center = new JPanel();
    JPanel mid = new JPanel();
    JLabel l_host = new JLabel("IP address");
    JLabel l_port = new JLabel("Port");
    JTextField t_host = new JTextField();
    JTextField t_port = new JTextField();
    JTextArea t_message = new JTextArea(5, 10);
    JScrollPane scr_pane = new JScrollPane(this.t_message);
    JButton b_start = new JButton("Measure");
    JButton b_stop = new JButton("Stop");

    public static void main(String[] args) {
        JavaSample1 test = new JavaSample1("8847");
        test.setDefaultCloseOperation(3);
        test.setSize(250, 320);
        test.setLocationRelativeTo(null);
        test.setVisible(true);
    }

    public JavaSample1(String title) {
        this.setTitle(title);
        this.Center.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.2;
        gbc.weighty = 1.5;
        this.Center.add((Component)this.l_host, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 1.5;
        this.Center.add((Component)this.l_port, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.8;
        gbc.weighty = 1.5;
        this.Center.add((Component)this.t_host, gbc);
        this.t_host.setText(this.host);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.8;
        gbc.weighty = 1.5;
        this.Center.add((Component)this.t_port, gbc);
        this.t_port.setText("8802");
        this.t_port.setEditable(false);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        this.Center.add((Component)this.mid, gbc);
        GridLayout layout_mid = new GridLayout(1, 2);
        layout_mid.setHgap(10);
        this.mid.setLayout(layout_mid);
        this.mid.add(this.b_start);
        this.mid.add(this.b_stop);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weighty = 7.0;
        gbc.gridwidth = 2;
        this.Center.add((Component)this.scr_pane, gbc);
        this.t_message.setEditable(false);
        this.t_message.setLineWrap(true);
        this.add(this.Center);
        this.b_start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JavaSample1.this.do_Action(":START");
            }
        });
        this.b_stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JavaSample1.this.do_Action(":ABORT");
            }
        });
    }

    private void do_Action(String message) {
        Socket socket = null;
        try {
            String host = this.t_host.getText();
            if (host.equals("")) {
                JOptionPane.showMessageDialog(this, "Please input the host name .", "Warning", 2);
                return;
            }
            try {
                socket = new Socket(host, Integer.parseInt("8802"));
                this.t_message.append("\nConnect" + socket.getRemoteSocketAddress() + "\n");
                PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                out.println(message);
                if (message.equals(":START")) {
                    this.t_message.append("Start measuring\n");
                } else {
                    this.t_message.append("Stop\n");
                }
                out.close();
            }
            catch (AccessControlException e) {
                JOptionPane.showMessageDialog(this, "Can't connect .\n Please confirm the communication setting .", "Error", 0);
            }
            catch (ConnectException e) {
                JOptionPane.showMessageDialog(this, "Can't connect .\n Please confirm the communication setting .", "Error", 0);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Can't connect .\n Please confirm the communication setting .", "Error", 0);
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                    this.t_message.append("Disconnect\n");
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Disconnected.\nPlease confirm the communication setting .", "Error", 0);
                }
            }
        }
    }
}

