Imports System.Net
Imports System.Net.Sockets
Imports System.Text
Public Class Form1
    Private netStream As NetworkStream
    Private MsgBuf As String

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Try
            Dim client As New TcpClient(TextBox1.Text, Val(TextBox2.Text))   'Set Tcp Client
            netStream = client.GetStream()                     'Open Tcp Client
            netStream.WriteTimeout = 100000
            netStream.ReadTimeout = 100000
            Button1.Enabled = False
            Button2.Enabled = True
            Button3.Enabled = True
            Button4.Enabled = True
            TextBox3.Enabled = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Try
            netStream.Close()                                  'Close Tcp Client
            Button1.Enabled = True
            Button2.Enabled = False
            Button3.Enabled = False
            Button4.Enabled = False
            TextBox3.Enabled = False
            Timer1.Enabled = False
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        Timer1.Interval = 3000                             'Set Interval
        Timer1.Enabled = True
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        stop_timer()
    End Sub
    Private Sub stop_timer()
        Timer1.Enabled = False
        TextBox3.SelectedText = "Stop"
    End Sub
    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        Dim data As Integer
        SendMsg(":HEADER OFF")                                   'Header OFF
        SendQueryMsg(":STATUS?")
        data = Val(MsgBuf)

        If (data = 0) Then
            TextBox3.SelectedText = "Stopping" & vbCrLf
        End If

        If ((data And &H1) <> 0) Then                                                   ' bit0
            TextBox3.SelectedText = "Starting" & vbCrLf
        End If

        If ((data And &H2) <> 0) Then                                                   'bit1
            TextBox3.SelectedText = "Storing" & vbCrLf
        End If

        If ((data And &H4) <> 0) Then                                                   ' bit2
            TextBox3.SelectedText = "Awaiting trigger" & vbCrLf
        End If

        If ((data And &H8) <> 0) Then                                                   ' bit3
            TextBox3.SelectedText = "Pre-trigger wait period" & vbCrLf
        End If

        If ((data And &H10) <> 0) Then                                                  ' bit4
            TextBox3.SelectedText = "Acquiring a waveform" & vbCrLf
        End If

        If ((data And &H20) <> 0) Then                                                  ' bit5
            TextBox3.SelectedText = "Saving" & vbCrLf
        End If

        If ((data And &H40) <> 0) Then                                                  ' bit6
            TextBox3.SelectedText = "Printing" & vbCrLf
        End If


    End Sub
    Private Sub SendMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            netStream.Write(Encoding.ASCII.GetBytes(strMsg), 0, strMsg.Length)            'Send command
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            netStream.Write(Encoding.ASCII.GetBytes(strMsg), 0, strMsg.Length)           'Send command
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                   'Wait receive command
                Check = netStream.ReadByte()
                If Chr(Check) = vbLf Then
                    Exit Do
                ElseIf Chr(Check) = vbCr Then
                Else
                    MsgBuf = MsgBuf & Chr(Check)
                End If
            Loop
            MsgBuf = MsgBuf & vbCrLf
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub TextBox3_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox3.TextChanged

    End Sub
    Private Sub Label1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label1.Click

    End Sub
    Private Sub TextBox2_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox2.TextChanged

    End Sub
    Private Sub TextBox1_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox1.TextChanged

    End Sub
    Private Sub Label2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label2.Click

    End Sub
End Class
