'********************************************************************************************
'*                                                                                          *
'*  Sets the sinusoidal wave to the CH1-1.                                                  *
'*                                                                                          *
'********************************************************************************************
Imports System
Imports System.Text
Imports System.IO
Imports System.Net
Imports System.Net.Sockets
Imports System.Threading
Imports Microsoft.VisualBasic


Public Class Form1
    Inherits System.Windows.Forms.Form

    Dim g_Ipe As IPEndPoint = Nothing
    Dim g_Socket As Socket = Nothing

#Region " Windows form designer create."

    Public Sub New()
        MyBase.New()

        InitializeComponent()

        BTN_DIS_CONNECT.Enabled() = False
    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub


    Private components As System.ComponentModel.IContainer

    Friend WithEvents LBL_IP_ADDRESS As System.Windows.Forms.Label
    Friend WithEvents LBL_PORT As System.Windows.Forms.Label
    Friend WithEvents TXT_BOX_IP As System.Windows.Forms.TextBox
    Friend WithEvents TXT_BOX_PORT As System.Windows.Forms.TextBox
    Friend WithEvents LBL_STATUS As System.Windows.Forms.Label
    Friend WithEvents BTN_CONNECT As System.Windows.Forms.Button
    Friend WithEvents BTN_DIS_CONNECT As System.Windows.Forms.Button
    Friend WithEvents LBL_STS As System.Windows.Forms.Label
    Friend WithEvents BTN_EXEC As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.LBL_IP_ADDRESS = New System.Windows.Forms.Label()
        Me.LBL_PORT = New System.Windows.Forms.Label()
        Me.TXT_BOX_IP = New System.Windows.Forms.TextBox()
        Me.TXT_BOX_PORT = New System.Windows.Forms.TextBox()
        Me.LBL_STATUS = New System.Windows.Forms.Label()
        Me.BTN_CONNECT = New System.Windows.Forms.Button()
        Me.BTN_DIS_CONNECT = New System.Windows.Forms.Button()
        Me.BTN_EXEC = New System.Windows.Forms.Button()
        Me.LBL_STS = New System.Windows.Forms.Label()
        Me.SuspendLayout()
        '
        'LBL_IP_ADDRESS
        '
        Me.LBL_IP_ADDRESS.Location = New System.Drawing.Point(8, 8)
        Me.LBL_IP_ADDRESS.Name = "LBL_IP_ADDRESS"
        Me.LBL_IP_ADDRESS.Size = New System.Drawing.Size(64, 16)
        Me.LBL_IP_ADDRESS.TabIndex = 1
        Me.LBL_IP_ADDRESS.Text = "IP address"
        '
        'LBL_PORT
        '
        Me.LBL_PORT.Location = New System.Drawing.Point(8, 32)
        Me.LBL_PORT.Name = "LBL_PORT"
        Me.LBL_PORT.Size = New System.Drawing.Size(64, 16)
        Me.LBL_PORT.TabIndex = 1
        Me.LBL_PORT.Text = "Port"
        '
        'TXT_BOX_IP
        '
        Me.TXT_BOX_IP.Location = New System.Drawing.Point(88, 8)
        Me.TXT_BOX_IP.Name = "TXT_BOX_IP"
        Me.TXT_BOX_IP.Size = New System.Drawing.Size(152, 19)
        Me.TXT_BOX_IP.TabIndex = 2
        Me.TXT_BOX_IP.Text = "192.168.0.199"
        '
        'TXT_BOX_PORT
        '
        Me.TXT_BOX_PORT.Location = New System.Drawing.Point(88, 29)
        Me.TXT_BOX_PORT.Name = "TXT_BOX_PORT"
        Me.TXT_BOX_PORT.Size = New System.Drawing.Size(152, 19)
        Me.TXT_BOX_PORT.TabIndex = 2
        Me.TXT_BOX_PORT.Text = "8802"
        '
        'LBL_STATUS
        '
        Me.LBL_STATUS.Location = New System.Drawing.Point(88, 56)
        Me.LBL_STATUS.Name = "LBL_STATUS"
        Me.LBL_STATUS.Size = New System.Drawing.Size(152, 19)
        Me.LBL_STATUS.TabIndex = 3
        Me.LBL_STATUS.Text = "Disconnect"
        '
        'BTN_CONNECT
        '
        Me.BTN_CONNECT.Location = New System.Drawing.Point(8, 88)
        Me.BTN_CONNECT.Name = "BTN_CONNECT"
        Me.BTN_CONNECT.Size = New System.Drawing.Size(112, 24)
        Me.BTN_CONNECT.TabIndex = 4
        Me.BTN_CONNECT.Text = "Connect"
        '
        'BTN_DIS_CONNECT
        '
        Me.BTN_DIS_CONNECT.Location = New System.Drawing.Point(128, 88)
        Me.BTN_DIS_CONNECT.Name = "BTN_DIS_CONNECT"
        Me.BTN_DIS_CONNECT.Size = New System.Drawing.Size(112, 24)
        Me.BTN_DIS_CONNECT.TabIndex = 4
        Me.BTN_DIS_CONNECT.Text = "Disconnect"
        '
        'BTN_EXEC
        '
        Me.BTN_EXEC.Enabled = False
        Me.BTN_EXEC.Location = New System.Drawing.Point(8, 120)
        Me.BTN_EXEC.Name = "BTN_EXEC"
        Me.BTN_EXEC.Size = New System.Drawing.Size(112, 24)
        Me.BTN_EXEC.TabIndex = 4
        Me.BTN_EXEC.Text = "Execute"
        '
        'LBL_STS
        '
        Me.LBL_STS.Location = New System.Drawing.Point(8, 56)
        Me.LBL_STS.Name = "LBL_STS"
        Me.LBL_STS.Size = New System.Drawing.Size(64, 16)
        Me.LBL_STS.TabIndex = 1
        Me.LBL_STS.Text = "Status"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 12)
        Me.ClientSize = New System.Drawing.Size(248, 157)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.LBL_STS, Me.BTN_CONNECT, Me.LBL_STATUS, Me.TXT_BOX_IP, Me.LBL_IP_ADDRESS, Me.LBL_PORT, Me.TXT_BOX_PORT, Me.BTN_DIS_CONNECT, Me.BTN_EXEC})
        Me.MaximizeBox = False
        Me.MinimizeBox = False
        Me.Name = "Form1"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "Form1"
        Me.ResumeLayout(False)

    End Sub

#End Region
    '****************************************************************
    '*  Connect                                                     *
    '****************************************************************
    Private Sub BTN_CONNECT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CONNECT.Click
        If (TXT_BOX_IP.Text = "") Then
            Exit Sub
        End If

        If (TXT_BOX_PORT.Text = "") Then
            Exit Sub
        End If

        LBL_STATUS.Text = "Waiting..."
        System.Windows.Forms.Application.DoEvents()

        Dim tmpIp As IPHostEntry = Dns.Resolve(TXT_BOX_IP.Text)
        Dim tmpIpe As New IPEndPoint(tmpIp.AddressList(0), Val(TXT_BOX_PORT.Text))
        Dim tmpS As New Socket(tmpIpe.AddressFamily, SocketType.Stream, ProtocolType.Tcp)

        tmpS.Connect(tmpIpe)
        g_Socket = tmpS
        g_Ipe = tmpIpe

        ReciveMsg()

        LBL_STATUS.Text = "Connect"
        TXT_BOX_IP.Enabled() = False
        TXT_BOX_PORT.Enabled() = False
        BTN_CONNECT.Enabled() = False
        BTN_DIS_CONNECT.Enabled() = True
        BTN_EXEC.Enabled() = True
    End Sub


    '****************************************************************
    '*  Disconnect                                                  *
    '****************************************************************
    Private Sub BTN_DIS_CONNECT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_DIS_CONNECT.Click
        g_Socket.Shutdown(SocketShutdown.Both)
        g_Socket.Close()

        Do While (g_Socket.Connected = True)
            LBL_STATUS.Text = "Waiting..."
            System.Windows.Forms.Application.DoEvents()
        Loop

        LBL_STATUS.Text = "Disconnect"
        TXT_BOX_IP.Enabled() = True
        TXT_BOX_PORT.Enabled() = True
        BTN_CONNECT.Enabled() = True
        BTN_DIS_CONNECT.Enabled() = False
        BTN_EXEC.Enabled() = False
    End Sub


    '****************************************************************
    '*  Transmit the data                                           *
    '****************************************************************
    Private Sub SendMsg(ByRef strMsg As String)
        Dim strTemp = strMsg & Chr(13) & Chr(10)
        Dim ASCII As Encoding = Encoding.ASCII
        Dim ByteGet As [Byte]() = ASCII.GetBytes(strTemp)
        g_Socket.Send(ByteGet, ByteGet.Length, SocketFlags.None)
    End Sub


    '****************************************************************
    '*  Transmit and recieve the data                               *
    '****************************************************************
    Dim MsgBuf As String

    Private Sub QueryMsg(ByRef strMsg As String)
        Dim deli As String
        Dim buf As String
        buf = LBL_STATUS.Text
        LBL_STATUS.Text = "Reciving..."
        SendMsg(strMsg)
        ReciveMsg()
        LBL_STATUS.Text = buf
    End Sub


    '****************************************************************
    '*  Recieve the data                                            *
    '****************************************************************
    Private Sub ReciveMsg()
        Dim ASCII As Encoding = Encoding.ASCII
        Dim RecvBytes(255) As [Byte]
        Dim bytes As Int32 = g_Socket.Receive(RecvBytes, RecvBytes.Length, SocketFlags.None)
        MsgBuf = ASCII.GetString(RecvBytes, 0, bytes)
    End Sub


    '****************************************************************
    '*  Execute                                                     *
    '****************************************************************
    Private Sub BTN_EXEC_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_EXEC.Click
        Dim data As Double
        Dim i As Integer
        Dim temp As String

        BTN_EXEC.Enabled() = False
        temp = LBL_STATUS.Text
        LBL_STATUS.Text = "Receiving..."

        SendMsg(":HEADER OFF")
        SendMsg(":FUNCTION MEM")
        SendMsg(":CONFIGURE:SHOT 25")
        QueryMsg(":MEMORY:PREPARE;*OPC?")
        SendMsg(":MEMORY:POINT CH1_1,0")

        For i = 0 To 2500
            SendMsg(":MEMORY:ADATA " & Str(Int(10000 * System.Math.Sin(3.14 * i / 200))))
        Next

        BTN_EXEC.Enabled() = True
        LBL_STATUS.Text = temp
    End Sub
End Class
