
Imports System.Net
Imports System.Net.Sockets
Imports System.Text

Public Class Form1
    Dim netStream As NetworkStream
    Dim MsgBuf As String

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Try
            Dim client As New TcpClient(TextBox1.Text, Val(TextBox2.Text))    'Set Tcp Client
            netStream = client.GetStream()                     'Open Tcp Client
            netStream.WriteTimeout = 100000
            netStream.ReadTimeout = 100000
            Button1.Enabled = False
            Button2.Enabled = True
            Button3.Enabled = True
            TextBox3.Enabled = True
            TextBox4.Enabled = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Try
            netStream.Close()                                 'Close Tcp Client
            Button1.Enabled = True
            Button2.Enabled = False
            Button3.Enabled = False
            TextBox3.Enabled = False
            TextBox4.Enabled = False
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        '*******************************************************************************
        ' LAN SAMPLE PROGRAM NO.1
        '
        ' This program connects to 8847 and do the sending and receiving of a command.
        ' When push a command execute button and input the command
        ' that wants to transmit it to the column of a command it is transmitted
        ' The answer is displayed to a text box, in the case of the command that is included (? ).  
        '*******************************************************************************

        If InStr(TextBox3.Text, "?") = 0 Then                  
            SendMsg(TextBox3.Text)                         'Send command
            TextBox4.Text = ""

        Else

            SendQueryMsg(TextBox3.Text)                          'Send command and receive query
            TextBox4.Text = MsgBuf

        End If

    End Sub
    Private Sub SendMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            netStream.Write(Encoding.ASCII.GetBytes(strMsg), 0, strMsg.Length)            'Send command
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            netStream.Write(Encoding.ASCII.GetBytes(strMsg), 0, strMsg.Length)            'Send command
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                   'Wait receive command
                Check = netStream.ReadByte()
                If Chr(Check) = vbLf Then
                    Exit Do
                ElseIf Chr(Check) = vbCr Then
                Else
                    MsgBuf = MsgBuf & Chr(Check)
                End If
            Loop
            MsgBuf = MsgBuf & vbCrLf
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub


End Class
