﻿'*******************************************************************************
'With this program, when the [Measure] button is pressed, the instrument is changed to 
'the binary communication mode and the measured value is acquired after triggering.
'The received binary data are then converted to the ASCII character string.
'*******************************************************************************

Public Class Form1
    Dim LanSocket As System.Net.Sockets.TcpClient                                   'TCP client socket
    Dim MsgBufbin() As Byte                                                         'Receiving buffer(Byte type array)

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim ip As System.Net.IPAddress = New System.Net.IPAddress(0)                'IP address
        Dim port As Integer                                                         'Port number

        Dim val1(3) As Byte
        Dim val1Single As Single
        Dim val2(3) As Byte
        Dim val2Single As Single

        Button1.Enabled = False

        Try

            LanSocket = New System.Net.Sockets.TcpClient                            'Create TCP socket
            If Not (System.Net.IPAddress.TryParse(TextBox1.Text, ip)) Then
                MsgBox("Error. Plese check the IP address.")
                Exit Sub
            End If
            port = Convert.ToInt32(TextBox2.Text)
            LanSocket.Connect(ip, port)                                             'Connect

            SendMsg("*RST")                                                         'Reset
            SendMsg(":TRIGger EXTernal")                                            'Trigger:External
            SendMsg(":FORMat:DATA REAL")                                            'Data format:Binary
            SendMsg("*TRG")                                                         'Trigger
            SendQueryMsgBin(":MEASure?")                                            'Acquire measured value

            Array.Copy(MsgBufbin, 0, val1, 0, 4)                                    'Measurement value1
            Array.Copy(MsgBufbin, 4, val2, 0, 4)                                    'Measurement value2

            val1Single = ConvertBin2Single(val1)                                    'Convert to value
            val2Single = ConvertBin2Single(val2)

            TextBox3.Text = BitConverter.ToString(MsgBufbin)
            TextBox4.Text = val1Single.ToString
            TextBox5.Text = val2Single.ToString

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try


        Try
            LanSocket.Close()                                                       'Disconnect
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        Button1.Enabled = True

    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Dim SendBuffer As Byte()
        Try
            strMsg = strMsg & vbCrLf
            SendBuffer = System.Text.Encoding.Default.GetBytes(strMsg)
            LanSocket.GetStream.Write(SendBuffer, 0, SendBuffer.Length)             'Send message
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsgBin(ByVal strMsg As String)
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            Dim Checkstr As String
            Dim digit As Integer
            Dim rcvsize As Integer = 0

            Check = ReadByteLan()                                                   'Receive #
            If Not Chr(Check) = "#" Then
                Exit Sub
            End If

            Check = ReadByteLan()                                                   'Receive number of receiving byte digits
            Checkstr = Chr(Check)                                                   'Convert character code to character
            digit = Convert.ToInt32(Checkstr)                                       'Convert character to value

            For index = 1 To digit
                Check = ReadByteLan()                                               'Receive number of receiving bytes
                Checkstr = Chr(Check)                                               'Convert character code to character
                rcvsize += Convert.ToInt32(Checkstr) * Math.Pow(10, (index - 1))    'Binary size to be acquired
            Next

            MsgBufbin = Nothing
            ReDim MsgBufbin(rcvsize - 1)
            For index = 1 To rcvsize
                Check = ReadByteLan()
                MsgBufbin(index - 1) = BitConverter.GetBytes(Check)(0)              'Receive data
            Next

            Do                                                                      'Receive terminator
                Check = ReadByteLan()
                If Chr(Check) = vbLf Then
                    Exit Do
                End If
            Loop

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Function ReadByteLan() As Integer
        Dim Length As Integer
        Dim ReceiveBuffer(1) As Byte
        Do
            If LanSocket.GetStream.DataAvailable Then
                Length = LanSocket.GetStream.Read(ReceiveBuffer, 0, 1)              'Receive data
                Exit Do
            End If
        Loop
        ReadByteLan = ReceiveBuffer(0)
    End Function

    Private Function ConvertBin2Single(ByVal val() As Byte) As Single
        Dim valSingle As Single

        Array.Reverse(val)                                                          'Convert to little endian
        valSingle = BitConverter.ToSingle(val, 0)                                   'Convert byte string

        ConvertBin2Single = valSingle
    End Function

End Class