﻿'*******************************************************************************
'このプログラムは、[測定]ボタンを押すとトリガや測定周波数などの設定を行った後、
'トリガをかけて測定値を取得します。
'*******************************************************************************

Public Class Form1
    Dim MsgBuf As String = ""                                   '受信バッファ

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        'シリアルポートの設定
        SerialPort1.PortName = TextBox1.Text                    'ポート名の設定
        SerialPort1.BaudRate = 9600                             '通信速度の設定
        SerialPort1.NewLine = vbCrLf                            'ターミネータの設定
        SerialPort1.Handshake = IO.Ports.Handshake.None         'ハンドシェイクの設定

        Button1.Enabled = False

        Try
            SerialPort1.Open()                                  'シリアルポートオープン

            SendMsg("*RST")                                     'リセット
            SendMsg(":TRIGger EXTernal")                        'トリガ：外部トリガ
            SendMsg(":FREQuency 1E+06")                         '周波数：1MHz
            SendMsg("*TRG")                                     'トリガ
            SendQueryMsg(":MEASure?")                           '測定値の取得

            TextBox2.Text = MsgBuf                              '測定値の表示

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        If SerialPort1.IsOpen Then
            Try
                SerialPort1.Close()                             'シリアルポートクローズ
            Catch ex As Exception
                MsgBox(ex.Message)
            End Try
        End If

        Button1.Enabled = True

    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            SerialPort1.WriteLine(strMsg)                       'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                  '応答受信まで待つ
                Check = SerialPort1.ReadByte()
                If Chr(Check) = vbLf Then
                    Exit Do
                ElseIf Chr(Check) = vbCr Then
                Else
                    MsgBuf = MsgBuf & Chr(Check)
                End If
            Loop
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub
End Class