﻿'*******************************************************************************
'このプログラムは、アナライザモードで掃引測定を行います。
'掃引条件を入力し[アナライザ測定]ボタンを押すと、結果がテキストボックスに表示されます。
'[保存]ボタンを押すと結果をテキストファイルに保存することができます。
'*******************************************************************************

Public Class Form1
    Dim LanSocket As System.Net.Sockets.TcpClient                               'TCPクライアントsocket
    Dim MsgBuf As String = ""                                                   '受信バッファ

    Private Sub Form1_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        ComboBox1.SelectedIndex = 1
    End Sub

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Dim ip As System.Net.IPAddress = New System.Net.IPAddress(0)            'IPアドレス
        Dim port As Integer                                                     'ポート番号

        Try
            LanSocket = New System.Net.Sockets.TcpClient                        'TCPインスタンスの生成
            If Not (System.Net.IPAddress.TryParse(TextBox1.Text, ip)) Then
                MsgBox("IPアドレスが正しくありません。")
                Exit Sub
            End If
            port = Convert.ToInt32(TextBox2.Text)
            LanSocket.Connect(ip, port)                                         '接続

            Button1.Enabled = False
            Button2.Enabled = False

            SendMsg("*RST")                                                     'リセット
            SendMsg(":MODE ANALyzer")                                           'モード：アナライザ
            SendMsg(":SWEep:TRIGger SEQuential")                                'トリガモード：シーケンシャル
            SendMsg(":LIST:STARt:STOP " + TextBox3.Text + "," _
                                        + TextBox4.Text + "," _
                                        + NumericUpDown1.Value.ToString + "," _
                                        + ComboBox1.SelectedItem)               '掃引範囲：1MHz～300MHz,101ポイント,LOG分割
            SendMsg(":PARameter1 Z")                                            'パラメータ1：Z
            SendMsg(":PARameter2 OFF")                                          'パラメータ2：OFF
            SendMsg(":PARameter3 Phase")                                        'パラメータ3：Phase
            SendMsg(":PARameter4 OFF")                                          'パラメータ4：OFF

            SendMsg("*TRG")                                                     'トリガ
            SendQueryMsg(":MEASure?")                                           '測定値取得
            ConvertCSV(MsgBuf)                                                  'CSV形式に変換

            TextBox5.Text = MsgBuf

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        Try
            LanSocket.Close()                                                   '切断
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        Button1.Enabled = True
        Button2.Enabled = True

    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Dim SendBuffer As Byte()
        Try
            strMsg = strMsg & vbCrLf
            SendBuffer = System.Text.Encoding.Default.GetBytes(strMsg)
            LanSocket.GetStream.Write(SendBuffer, 0, SendBuffer.Length)         'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Dim Length As Integer
        Dim ReceiveBuffer(1) As Byte
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                                  '応答受信まで待つ
                If LanSocket.GetStream.DataAvailable Then
                    Length = LanSocket.GetStream.Read(ReceiveBuffer, 0, 1)
                    Check = ReceiveBuffer(0)
                    If Chr(Check) = vbLf Then
                        Exit Do
                    ElseIf Chr(Check) = vbCr Then
                    Else
                        MsgBuf = MsgBuf & Chr(Check)
                    End If
                End If
            Loop
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub ConvertCSV(ByRef str As String)
        Dim strary() As String
        Dim pointnum As Integer

        strary = str.Split(",")                                                 '測定値を配列に変換
        pointnum = strary.Count / 3                                             '測定点の数

        str = Nothing
        For index = 0 To pointnum - 1
            str += strary(3 * index + 0) + ","                                  '周波数
            str += strary(3 * index + 1) + ","                                  '第1パラメータ測定値
            str += strary(3 * index + 2) + vbCrLf                               '第2パラメータ測定値
        Next

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        If SaveFileDialog1.ShowDialog() = DialogResult.OK Then
            Try
                Dim filename As String = SaveFileDialog1.FileName               'ファイル名を設定
                Dim fp As New System.IO.StreamWriter(filename, False, _
                    System.Text.Encoding.GetEncoding("shift_jis"))              'ファイルオープン
                fp.Write("Frequency,Z,Phase" + vbCrLf)                          'ヘッダをファイルに出力
                fp.Write(TextBox5.Text)                                         'データをファイルに出力
                fp.Close()                                                      'ファイルクローズ
            Catch Ex As Exception
                MsgBox(Ex.Message)
            End Try
        End If
    End Sub
End Class

