﻿'*******************************************************************************
'このプログラムは、本器に接続してコマンドの送受信を行います。
'コマンドの欄に送信したいコマンドを入力し、[送信]ボタンを押すと送信されます。
'応答があるコマンド（?が含まれるコマンド）の場合は、テキストボックスに応答が表示されます。
'*******************************************************************************

Public Class Form1
    Dim LanSocket As System.Net.Sockets.TcpClient                           'TCPクライアントsocket
    Dim MsgBuf As String = ""                                               '受信バッファ
    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Dim ip As System.Net.IPAddress = New System.Net.IPAddress(0)        'IPアドレス
        Dim port As Integer                                                 'ポート番号

        Try
            LanSocket = New System.Net.Sockets.TcpClient                    'TCPインスタンスの生成
            If Not (System.Net.IPAddress.TryParse(TextBox1.Text, ip)) Then
                MsgBox("IPアドレスが正しくありません。")
                Exit Sub
            End If
            port = Convert.ToInt32(TextBox2.Text)
            LanSocket.Connect(ip, port)                                     '接続

            Button1.Enabled = False
            Button2.Enabled = True
            Button3.Enabled = True
            TextBox3.Enabled = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Try
            LanSocket.Close()                                               '切断
            Button1.Enabled = True
            Button2.Enabled = False
            Button3.Enabled = False
            TextBox3.Enabled = False
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        If InStr(TextBox3.Text, "?") = 0 Then                               'コマンドに?が含まれない場合は、コマンド送信のみ
            SendMsg(TextBox3.Text)                                          'コマンド送信
            TextBox4.Text += "> " + TextBox3.Text + vbCrLf
        Else                                                                'コマンドに?が含まれる場合は、コマンド送信と応答受信
            SendQueryMsg(TextBox3.Text)                                     'コマンド送信と応答受信
            TextBox4.Text += "> " + TextBox3.Text + vbCrLf
            TextBox4.Text += "< " + MsgBuf
        End If

    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        TextBox4.Text = Nothing                                             '消去
    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Dim SendBuffer As Byte()
        Try
            strMsg = strMsg & vbCrLf
            SendBuffer = System.Text.Encoding.Default.GetBytes(strMsg)
            LanSocket.GetStream.Write(SendBuffer, 0, SendBuffer.Length)     'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Dim Length As Integer
        Dim ReceiveBuffer(1) As Byte
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                              '応答受信まで待つ
                If LanSocket.GetStream.DataAvailable Then
                    Length = LanSocket.GetStream.Read(ReceiveBuffer, 0, 1)
                    Check = ReceiveBuffer(0)
                    If Chr(Check) = vbLf Then
                        Exit Do
                    ElseIf Chr(Check) = vbCr Then
                    Else
                        MsgBuf = MsgBuf & Chr(Check)
                    End If
                End If
            Loop
            MsgBuf = MsgBuf & vbCrLf
        Catch Ex As Exception
            MsgBuf = vbCrLf
            MsgBox(Ex.Message)
        End Try
    End Sub

End Class

