﻿'*******************************************************************************
'このプログラムは、本器に接続してコマンドの送受信を行います。
'コマンドの欄に送信したいコマンドを入力し、[送信]ボタンを押すと送信されます。
'応答があるコマンド（?が含まれるコマンド）の場合は、テキストボックスに応答が表示されます。
'*******************************************************************************

Public Class Form1
    Dim MsgBuf As String = ""                                               '受信バッファ
    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Try
            SerialPort1.PortName = TextBox1.Text                            'ポートを指定
            SerialPort1.Open()                                              '接続
            Button1.Enabled = False
            Button2.Enabled = True
            Button3.Enabled = True
            TextBox2.Enabled = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        Try
            SerialPort1.Close()                                             '切断
            Button1.Enabled = True
            Button2.Enabled = False
            Button3.Enabled = False
            TextBox2.Enabled = False
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click

        If InStr(TextBox2.Text, "?") = 0 Then                               'コマンドに?が含まれない場合は、コマンド送信のみ
            SendMsg(TextBox2.Text)                                          'コマンド送信
            TextBox3.Text += "> " + TextBox2.Text + vbCrLf
        Else                                                                'コマンドに?が含まれる場合は、コマンド送信と応答受信
            SendQueryMsg(TextBox2.Text)                                     'コマンド送信と応答受信
            TextBox3.Text += "> " + TextBox2.Text + vbCrLf
            TextBox3.Text += "< " + MsgBuf
        End If

    End Sub

    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click
        TextBox3.Text = ""                                                  '消去
    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            SerialPort1.WriteLine(strMsg)                                   'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                              '応答受信まで待つ
                Check = SerialPort1.ReadByte()
                If Chr(Check) = vbLf Then
                    Exit Do
                ElseIf Chr(Check) = vbCr Then
                Else
                    MsgBuf = MsgBuf & Chr(Check)
                End If
            Loop
            MsgBuf = MsgBuf & vbCrLf
        Catch Ex As Exception
            MsgBuf = vbCrLf
            MsgBox(Ex.Message)
        End Try
    End Sub

End Class

