﻿'*******************************************************************************
'このプログラムは、アナライザモードで掃引測定を行います。
'掃引条件を入力し[アナライザ測定]ボタンを押すと、結果がテキストボックスに表示されます。
'[保存]ボタンを押すと結果をテキストファイルに保存することができます。
'*******************************************************************************

Public Class Form1
    Dim MsgBuf As String = ""                                                   '受信バッファ

    Private Sub Form1_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        ComboBox1.SelectedIndex = 1
    End Sub

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Try
            SerialPort1.PortName = TextBox1.Text                                'ポートを指定
            SerialPort1.Open()                                                  '接続
            Button1.Enabled = False
            Button2.Enabled = False

            SendMsg("*RST")                                                     'リセット
            SendMsg(":MODE ANALyzer")                                           'モード：アナライザ
            SendMsg(":SWEep:TRIGger SEQuential")                                'トリガモード：シーケンシャル
            SendMsg(":LIST:STARt:STOP " + TextBox2.Text + "," _
                                        + TextBox3.Text + "," _
                                        + NumericUpDown1.Value.ToString + "," _
                                        + ComboBox1.SelectedItem)               '掃引範囲：100Hz～120kHz,101ポイント,LOG分割
            SendMsg(":PARameter1 Z")                                            'パラメータ1：Z
            SendMsg(":PARameter3 Phase")                                        'パラメータ2：Phase

            SendMsg("*TRG")                                                     'トリガ
            SendQueryMsg(":MEASure?")                                           '測定値取得
            ConvertCSV(MsgBuf)                                                  'CSV形式に変換

            TextBox4.Text = MsgBuf

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        If SerialPort1.IsOpen Then
            SerialPort1.Close()                                                 '切断
        End If
        Button1.Enabled = True
        Button2.Enabled = True

    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            SerialPort1.WriteLine(strMsg)                                       'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                                  '応答受信まで待つ
                Check = SerialPort1.ReadByte()
                If Chr(Check) = vbLf Then
                    Exit Do
                ElseIf Chr(Check) = vbCr Then
                Else
                    MsgBuf = MsgBuf & Chr(Check)
                End If
            Loop
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub ConvertCSV(ByRef str As String)
        Dim strary() As String
        Dim pointnum As Integer

        strary = str.Split(",")                                                 '測定値を配列に変換
        pointnum = strary.Count / 3                                             '測定点の数

        str = Nothing
        For index = 0 To pointnum - 1
            str += strary(3 * index + 0) + ","                                  '周波数
            str += strary(3 * index + 1) + ","                                  '第1パラメータ測定値
            str += strary(3 * index + 2) + vbCrLf                               '第2パラメータ測定値
        Next

    End Sub

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        If SaveFileDialog1.ShowDialog() = DialogResult.OK Then
            Try
                Dim filename As String = SaveFileDialog1.FileName               'ファイル名を設定
                Dim fp As New System.IO.StreamWriter(filename, False, _
                    System.Text.Encoding.GetEncoding("shift_jis"))              'ファイルオープン
                fp.Write("Frequency,Z,Phase" + vbCrLf)                          'ヘッダをファイルに出力
                fp.Write(TextBox4.Text)                                         'データをファイルに出力
                fp.Close()                                                      'ファイルクローズ
            Catch Ex As Exception
                MsgBox(Ex.Message)
            End Try
        End If
    End Sub
End Class

