﻿'*******************************************************************************
'このプログラムは、LCRモードでオープン補正、ショート補正を行います。
'[オープン補正の実行]または[ショート補正の実行]を押すと補正値を取得します。
'補正値の取得には時間がかかるため、イベントステータスレジスタのCEMビットを監視し、
'補正が終わるまで待ちます。
'*******************************************************************************

Public Class Form1
    Dim MsgBuf As String = ""                                                               '受信バッファ

    Enum ESE0
        REF = 128
        COF = 64
        LOF = 32
        MOF = 16
        MUF = 8
        IDX = 4
        EOM = 2
        CEM = 1
    End Enum

    Private Sub Button1_Click_1(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        ExecAdjust("OPEN")
    End Sub

    Private Sub Button2_Click_1(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        ExecAdjust("SHORT")
    End Sub

    Private Sub ExecAdjust(ByVal mode As String)
        Try
            SerialPort1.PortName = TextBox1.Text                                            'ポートを指定
            SerialPort1.Open()                                                              '接続
            Button1.Enabled = False
            Button2.Enabled = False

            SendMsg(":MODE LCR")                                                            'モード：LCR
            SendMsg(":TRIGger EXTernal")                                                    'トリガ：外部トリガ
            SendQueryMsg(":ESR0?")                                                          'イベントステータスレジスタの確認

            Select Case mode
                Case "OPEN"
                    MsgBox("オープン補正を行います。" + vbCrLf + _
                           "フィクスチャがオープン状態になっていることを確認してください。")    '確認メッセージ

                    SendMsg(":CORRection:OPEN ALL")                                         'オープン補正の実行

                Case "SHORT"
                    MsgBox("ショート補正を行います。" + vbCrLf + _
                           "フィクスチャがショート状態になっていることを確認してください。")    '確認メッセージ

                    SendMsg(":CORRection:SHORt ALL")                                        'ショート補正の実行

            End Select

            Do                                                                              '補正完了まで待つ
                SendQueryMsg(":ESR0?")                                                      'イベントステータスレジスタの確認
                If MsgBuf And ESE0.CEM Then                                                 '補正完了ビットを監視
                    Exit Do
                End If
                System.Threading.Thread.Sleep(500)
                System.Windows.Forms.Application.DoEvents()

                If ProgressBar1.Value < ProgressBar1.Maximum Then
                    ProgressBar1.Value += 1                                                 'プログレスバーの処理
                End If
            Loop

            ProgressBar1.Value = ProgressBar1.Maximum

            Select Case mode
                Case "OPEN"
                    SendQueryMsg(":CORRection:OPEN:ERRor?")                                 '確認

                Case "SHORT"
                    SendQueryMsg(":CORRection:SHORt:ERRor?")

            End Select

            Select Case MsgBuf
                Case "0"
                    MsgBox("補正が正常に終了しました。")

                Case "1"
                    MsgBox("補正が異常終了しました。")

                Case "2"
                    MsgBox("レンジが未確定の状態で補正が終了しました。")

            End Select

            ProgressBar1.Value = 0

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        If SerialPort1.IsOpen Then
            Try
                SerialPort1.Close()                                                         '切断
            Catch ex As Exception
                MsgBox(ex.Message)
            End Try
        End If
        Button1.Enabled = True
        Button2.Enabled = True
    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            SerialPort1.WriteLine(strMsg)                                                   'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                                              '応答受信まで待つ
                Check = SerialPort1.ReadByte()
                If Chr(Check) = vbLf Then
                    Exit Do
                ElseIf Chr(Check) = vbCr Then
                Else
                    MsgBuf = MsgBuf & Chr(Check)
                End If
            Loop
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

End Class

