﻿'*******************************************************************************
'With this program, open-circuit compensation and short-circuit compensation are executed in the LCR mode.
'Press [Execute open-circuit compensation] or [Execute short-circuit compensation] to acquire the compensation value.
'As it takes time to acquire the compensation value, wait until the compensation is completed 
'while monitoring the CEM bit of the event status resistor.
'*******************************************************************************

Public Class Form1
    Dim LanSocket As System.Net.Sockets.TcpClient                                           'TCP client socket
    Dim MsgBuf As String = ""                                                               'Receiving buffer

    Enum ESE0
        REF = 128
        COF = 64
        LOF = 32
        MOF = 16
        MUF = 8
        IDX = 4
        EOM = 2
        CEM = 1
    End Enum

    Private Sub Button1_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        ExecAdjust("OPEN")
    End Sub

    Private Sub Button2_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        ExecAdjust("SHORT")
    End Sub

    Private Sub ExecAdjust(ByVal mode As String)
        Dim ip As System.Net.IPAddress = New System.Net.IPAddress(0)                        'IP address
        Dim port As Integer                                                                 'Port number

        Try
            LanSocket = New System.Net.Sockets.TcpClient                                    'Create TCP socket
            If Not (System.Net.IPAddress.TryParse(TextBox1.Text, ip)) Then
                MsgBox("Error. Plese check the IP address.")
                Exit Sub
            End If
            port = Convert.ToInt32(TextBox2.Text)
            LanSocket.Connect(ip, port)                                                     'Connect

            Button1.Enabled = False
            Button2.Enabled = False

            SendMsg(":MODE LCR")                                                            'Mode:LCR
            SendMsg(":TRIGger EXTernal")                                                    'Trigger:External
            SendQueryMsg(":ESR0?")                                                          'Check event status resistor

            Select Case mode
                Case "OPEN"
                    MsgBox("Open-circuit compensation" + vbCrLf + _
                           "Check that the measurement cable is in an open circuit state.") 'Confirmation message

                    SendMsg(":CORRection:OPEN ALL")                                         'Execute open-circuit compensation

                Case "SHORT"
                    MsgBox("Short-circuit compensation" + vbCrLf + _
                           "Check that the measurement cable is in an open circuit state.") 'Confirmation message

                    SendMsg(":CORRection:SHORt ALL")                                        'Execute short-circuit compensation

            End Select

            Do                                                                              'Wait until compensation is completed
                SendQueryMsg(":ESR0?")                                                      'Check event status resistor
                If MsgBuf And ESE0.CEM Then                                                 'Monitor compensation completion bit
                    Exit Do
                End If
                System.Threading.Thread.Sleep(500)
                System.Windows.Forms.Application.DoEvents()

                If ProgressBar1.Value < ProgressBar1.Maximum Then
                    ProgressBar1.Value += 1                                                 'Progress bar processing
                End If
            Loop

            ProgressBar1.Value = ProgressBar1.Maximum

            Select Case mode
                Case "OPEN"
                    SendQueryMsg(":CORRection:OPEN:ERRor?")                                 'Check

                Case "SHORT"
                    SendQueryMsg(":CORRection:SHORt:ERRor?")

            End Select

            Select Case MsgBuf
                Case "0"
                    MsgBox("Compensation ended normally.")

                Case "1"
                    MsgBox("Compensation ended abnormally.")

                Case "2"
                    MsgBox("Compensation ended in a state in which the range has not been determined.")

            End Select

            ProgressBar1.Value = 0

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        Try
            LanSocket.Close()                                                               'Disconnect
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        Button1.Enabled = True
        Button2.Enabled = True
    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Dim SendBuffer As Byte()
        Try
            strMsg = strMsg & vbCrLf
            SendBuffer = System.Text.Encoding.Default.GetBytes(strMsg)
            LanSocket.GetStream.Write(SendBuffer, 0, SendBuffer.Length)                     'Send message
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Dim Length As Integer
        Dim ReceiveBuffer(1) As Byte
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                                              'Wait until response is received
                If LanSocket.GetStream.DataAvailable Then
                    Length = LanSocket.GetStream.Read(ReceiveBuffer, 0, 1)
                    Check = ReceiveBuffer(0)
                    If Chr(Check) = vbLf Then
                        Exit Do
                    ElseIf Chr(Check) = vbCr Then
                    Else
                        MsgBuf = MsgBuf & Chr(Check)
                    End If
                End If
            Loop
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

End Class

