﻿'*******************************************************************************
'このプログラムは、LCRモードでコンパレータ測定を行い、測定値と判定結果を表示します。
'上限値と下限値を設定し、[測定開始]を押してください。
'*******************************************************************************

Public Class Form1
    Dim LanSocket As System.Net.Sockets.TcpClient                                           'TCPクライアントsocket
    Dim MsgBuf As String = ""                                                               '受信バッファ
    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Dim strary() As String
        Dim ip As System.Net.IPAddress = New System.Net.IPAddress(0)                        'IPアドレス
        Dim port As Integer                                                                 'ポート番号

        Try
            LanSocket = New System.Net.Sockets.TcpClient                                    'TCPインスタンスの生成
            If Not (System.Net.IPAddress.TryParse(TextBox1.Text, ip)) Then
                MsgBox("IPアドレスが正しくありません。")
                Exit Sub
            End If
            port = Convert.ToInt32(TextBox2.Text)
            LanSocket.Connect(ip, port)                                                     '接続

            GroupBox1.Enabled = False

            SendMsg("*RST")                                                                 'リセット
            SendMsg(":TRIGger EXTernal")                                                    'トリガ：外部トリガ

            SendMsg(":COMParator ON")                                                       'コンパレータ機能：ON
            SendMsg(":COMParator:FLIMit:ABSolute " + TextBox4.Text + "," + TextBox3.Text)   'Z上下限値設定
            SendMsg(":COMParator:SLIMit:ABSolute " + TextBox6.Text + "," + TextBox5.Text)   'θ上下限値設定

            SendMsg("*TRG")                                                                 'トリガ

            SendQueryMsg(":MEASure?")                                                       '測定値と判定結果取得

            MsgBuf = MsgBuf.Replace(vbCrLf, "")                                             '改行を取る
            strary = MsgBuf.Split(",")                                                      '測定値をカンマで分割

            Label10.ForeColor = GetColorResultAll(strary(0))
            Label10.Text = GetStrResultAll(strary(0))

            TextBox7.Text = strary(1)

            Label8.ForeColor = GetColorResult(strary(2))
            Label8.Text = GetStrResult(strary(2))

            TextBox8.Text = strary(3)

            Label9.ForeColor = GetColorResult(strary(4))
            Label9.Text = GetStrResult(strary(4))

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        Try
            LanSocket.Close()                                                               '切断
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        GroupBox1.Enabled = True
    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Dim SendBuffer As Byte()
        Try
            strMsg = strMsg & vbCrLf
            SendBuffer = System.Text.Encoding.Default.GetBytes(strMsg)
            LanSocket.GetStream.Write(SendBuffer, 0, SendBuffer.Length)                     'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Dim Length As Integer
        Dim ReceiveBuffer(1) As Byte
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                                              '応答受信まで待つ
                If LanSocket.GetStream.DataAvailable Then
                    Length = LanSocket.GetStream.Read(ReceiveBuffer, 0, 1)
                    Check = ReceiveBuffer(0)
                    If Chr(Check) = vbLf Then
                        Exit Do
                    ElseIf Chr(Check) = vbCr Then
                    Else
                        MsgBuf = MsgBuf & Chr(Check)
                    End If
                End If
            Loop
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Function GetStrResultAll(ByVal str As String) As String
        Dim resultAll() As String = {"NG", "IN"}                                            '総合判定結果
        Dim ret As String = ""
        Select Case str
            Case "0"
                ret = resultAll(0)
            Case "1"
                ret = resultAll(1)
        End Select
        GetStrResultAll = ret
    End Function

    Private Function GetStrResult(ByVal str As String) As String
        Dim result() As String = {"LO", "IN", "HI", "-"}                                    '判定結果
        Dim ret As String = ""
        Select Case str
            Case "-1"
                ret = result(0)
            Case "0"
                ret = result(1)
            Case "1"
                ret = result(2)
            Case "2"
                ret = result(3)
        End Select
        GetStrResult = ret
    End Function

    Private Function GetColorResultAll(ByVal str As String) As Color
        Dim ret As Color = Color.Black
        Select Case str
            Case "0"
                ret = Color.Red
            Case "1"
                ret = Color.LimeGreen
        End Select
        GetColorResultAll = ret
    End Function

    Private Function GetColorResult(ByVal str As String) As Color
        Dim ret As Color = Color.Black
        Select Case str
            Case "-1"
                ret = Color.Red
            Case "0"
                ret = Color.LimeGreen
            Case "1"
                ret = Color.Red
            Case "2"
                ret = Color.Black
        End Select
        GetColorResult = ret
    End Function

End Class

