﻿'*******************************************************************************
'このプログラムは、[測定]ボタンを押すとトリガや測定周波数などの設定を行った後、
'トリガをかけて測定値を取得します。
'*******************************************************************************

Public Class Form1
    Dim LanSocket As System.Net.Sockets.TcpClient                           'TCPクライアントsocket
    Dim MsgBuf As String = ""                                               '受信バッファ
    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim ip As System.Net.IPAddress = New System.Net.IPAddress(0)        'IPアドレス
        Dim port As Integer                                                 'ポート番号

        Button1.Enabled = False

        Try
            LanSocket = New System.Net.Sockets.TcpClient                    'TCPインスタンスの生成
            If Not (System.Net.IPAddress.TryParse(TextBox1.Text, ip)) Then
                MsgBox("IPアドレスが正しくありません。")
                Exit Sub
            End If
            port = Convert.ToInt32(TextBox2.Text)
            LanSocket.Connect(ip, port)                                     '接続

            SendMsg("*RST")                                                 'リセット
            SendMsg(":TRIGger EXTernal")                                    'トリガ：外部トリガ
            SendMsg(":FREQuency 200E+03")                                   '周波数：200kHz
            SendMsg("*TRG")                                                 'トリガ
            SendQueryMsg(":MEASure?")                                       '測定値の取得

            TextBox3.Text = MsgBuf

            LanSocket.Close()
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        Button1.Enabled = True

    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Dim SendBuffer As Byte()
        Try
            strMsg = strMsg & vbCrLf
            SendBuffer = System.Text.Encoding.Default.GetBytes(strMsg)
            LanSocket.GetStream.Write(SendBuffer, 0, SendBuffer.Length)     'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Dim Length As Integer
        Dim ReceiveBuffer(1) As Byte
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                              '応答受信まで待つ
                If LanSocket.GetStream.DataAvailable Then
                    Length = LanSocket.GetStream.Read(ReceiveBuffer, 0, 1)
                    Check = ReceiveBuffer(0)
                    If Chr(Check) = vbLf Then
                        Exit Do
                    ElseIf Chr(Check) = vbCr Then
                    Else
                        MsgBuf = MsgBuf & Chr(Check)
                    End If
                End If
            Loop
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

End Class