﻿'*******************************************************************************
'このプログラムは、測定画面をBMP形式で保存することができます。
'*******************************************************************************

Public Class Form1
    Dim rcv_buf(300000) As Byte                                                 '受信バッファ

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Try
            Dim rcv_size As Integer = 0
            Dim recvfilesize As Integer
            Dim cmd As String

            SerialPort1.PortName = TextBox1.Text                                'ポートを指定
            SerialPort1.Open()                                                  '接続
            Button1.Enabled = False
            GroupBox1.Enabled = False

            SerialPort1.DiscardOutBuffer()
            SerialPort1.DiscardInBuffer()

            '----------------------------------------
            '名前を付けて保存ダイアログの表示
            '----------------------------------------
            SaveFileDialog1.Filter = "BMP (*.bmp)|*.bmp"
            SaveFileDialog1.FileName = Tbx_filename.Text
            SaveFileDialog1.InitialDirectory = Environment.SpecialFolder.DesktopDirectory

            If SaveFileDialog1.ShowDialog() = DialogResult.OK Then
                If Me.TabControl1.SelectedIndex = 0 Then
                    If Rbtn_nega.Checked Then
                        cmd = ":HCOPy:DATA? NEGAtive"
                    Else
                        cmd = ":HCOPy:DATA? POSItive"
                    End If
                Else
                    If Rbtn_color.Checked Then
                        cmd = ":HCOPy:DATA? COLor"
                    Else
                        cmd = ":HCOPy:DATA? MONochrome"
                    End If
                End If

                SerialPort1.Write(cmd + vbCrLf)                                 'コマンド送信

                '----------------------------------------
                '受信BMPサイズ確認
                '----------------------------------------
                Dim keta As Integer
                Dim rcv_totalsize As Integer = 0
                Dim recvfilesize_str As String = ""

                rcv_buf(0) = SerialPort1.ReadByte()                             '#の受信
                rcv_buf(0) = SerialPort1.ReadByte()                             '桁数の受信
                keta = Val(Convert.ToChar(rcv_buf(0)))

                For index = 1 To 6
                    rcv_buf(0) = SerialPort1.ReadByte()                         'バイト数の受信
                    recvfilesize_str += Convert.ToChar(rcv_buf(0))              'バイト列を文字列に変換
                Next
                recvfilesize = Val(recvfilesize_str) + 2                        'ターミネータバイト加算

                '----------------------------------------
                'プログレスバーの設定
                '----------------------------------------
                ProgressBar1.Maximum = recvfilesize
                ProgressBar1.Value = 0

                '----------------------------------------
                'BMPデータ受信
                '----------------------------------------
                Do
                    If SerialPort1.BytesToRead > 0 Then
                        rcv_size = SerialPort1.Read(rcv_buf, rcv_totalsize, 1000) '受信バッファを取得
                        rcv_totalsize += rcv_size
                    End If
                    ProgressBar1.Value = rcv_totalsize
                    If rcv_totalsize = recvfilesize Then
                        Exit Do
                    End If
                Loop

                '----------------------------------------
                'ファイル書き込み
                '----------------------------------------
                Dim fs As New System.IO.FileStream(SaveFileDialog1.FileName, System.IO.FileMode.Create, System.IO.FileAccess.Write)
                Try
                    fs.Write(rcv_buf, 0, recvfilesize - 2)
                Catch ex As Exception
                    MsgBox(ex.Message)
                End Try

                fs.Close()

                MsgBox("画像取得しました。")
                ProgressBar1.Value = 0
            End If

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        If SerialPort1.IsOpen Then
            SerialPort1.Close()                                                 '切断
        End If
        Button1.Enabled = True
        GroupBox1.Enabled = True

    End Sub
End Class

