﻿'*******************************************************************************
'このプログラムは、LCRモードでコンパレータ測定を行い、測定値と判定結果を表示します。
'上限値と下限値を設定し、[測定開始]を押してください。
'*******************************************************************************

Public Class Form1
    Dim MsgBuf As String = ""                                                               '受信バッファ
    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Dim strary() As String

        Try
            SerialPort1.PortName = TextBox1.Text                                            'ポートを指定
            SerialPort1.Open()                                                              '接続
            GroupBox1.Enabled = False

            SendMsg(":MODE LCR")                                                            ' LCRモード
            SendMsg(":TRIGger EXTernal")                                                    'トリガ：外部トリガ

            SendMsg(":COMParator ON")                                                       'コンパレータ機能：ON
            SendMsg(":COMParator:FLIMit:ABSolute " + TextBox3.Text + "," + TextBox2.Text)   'Z上下限値設定
            SendMsg(":COMParator:SLIMit:ABSolute " + TextBox5.Text + "," + TextBox4.Text)   'θ上下限値設定

            SendMsg("*TRG")                                                                 'トリガ

            SendQueryMsg(":MEASure?")                                                       '測定値と判定結果取得

            MsgBuf = MsgBuf.Replace(vbCrLf, "")                                             '改行を取る
            strary = MsgBuf.Split(",")                                                      '測定値をカンマで分割

            Label10.ForeColor = GetColorResultAll(strary(0))
            Label10.Text = GetStrResultAll(strary(0))

            TextBox6.Text = strary(1)

            Label8.ForeColor = GetColorResult(strary(2))
            Label8.Text = GetStrResult(strary(2))

            TextBox7.Text = strary(3)

            Label9.ForeColor = GetColorResult(strary(4))
            Label9.Text = GetStrResult(strary(4))

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        If SerialPort1.IsOpen Then
            Try
                SerialPort1.Close()                                                         '切断
            Catch ex As Exception
                MsgBox(ex.Message)
            End Try
        End If

        GroupBox1.Enabled = True
    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            SerialPort1.WriteLine(strMsg)                                                   'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsg(ByVal strMsg As String)
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            MsgBuf = Nothing
            Do                                                                              '応答受信まで待つ
                Check = SerialPort1.ReadByte()
                If Chr(Check) = vbLf Then
                    Exit Do
                ElseIf Chr(Check) = vbCr Then
                Else
                    MsgBuf = MsgBuf & Chr(Check)
                End If
            Loop
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Function GetStrResultAll(ByVal str As String) As String
        Dim resultAll() As String = {"NG", "IN"}                                                '総合判定結果
        Dim ret As String = ""
        Select Case str
            Case "0"
                ret = resultAll(0)
            Case "1"
                ret = resultAll(1)
        End Select
        GetStrResultAll = ret
    End Function

    Private Function GetStrResult(ByVal str As String) As String
        Dim result() As String = {"LO", "IN", "HI", "-"}                                        '判定結果
        Dim ret As String = ""
        Select Case str
            Case "-1"
                ret = result(0)
            Case "0"
                ret = result(1)
            Case "1"
                ret = result(2)
            Case "2"
                ret = result(3)
        End Select
        GetStrResult = ret
    End Function

    Private Function GetColorResultAll(ByVal str As String) As Color
        Dim ret As Color = Color.Black
        Select Case str
            Case "0"
                ret = Color.Red
            Case "1"
                ret = Color.LimeGreen
        End Select
        GetColorResultAll = ret
    End Function

    Private Function GetColorResult(ByVal str As String) As Color
        Dim ret As Color = Color.Black
        Select Case str
            Case "-1"
                ret = Color.Red
            Case "0"
                ret = Color.LimeGreen
            Case "1"
                ret = Color.Red
            Case "2"
                ret = Color.Black
        End Select
        GetColorResult = ret
    End Function

End Class

