﻿'*******************************************************************************
'このプログラムは、[測定]ボタンを押すと、バイナリ通信モードに変更し、
'トリガをかけて測定値を取得します。
'受信したバイナリデータをASCII文字列に変換します。
'*******************************************************************************

Public Class Form1
    Dim LanSocket As System.Net.Sockets.TcpClient                                   'TCPクライアントsocket
    Dim MsgBufbin() As Byte                                                         '受信バッファ（バイト型配列）

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim ip As System.Net.IPAddress = New System.Net.IPAddress(0)                'IPアドレス
        Dim port As Integer                                                         'ポート番号

        Dim val1(3) As Byte
        Dim val1Single As Single
        Dim val2(3) As Byte
        Dim val2Single As Single

        Button1.Enabled = False

        Try

            LanSocket = New System.Net.Sockets.TcpClient                            'TCPインスタンスの生成
            If Not (System.Net.IPAddress.TryParse(TextBox1.Text, ip)) Then
                MsgBox("IPアドレスが正しくありません。")
                Exit Sub
            End If
            port = Convert.ToInt32(TextBox2.Text)
            LanSocket.Connect(ip, port)                                             '接続

            SendMsg("*RST")                                                         'リセット
            SendMsg(":TRIGger EXTernal")                                            'トリガ：外部トリガ
            SendMsg(":FORMat:DATA REAL")                                            'データ転送モード：バイナリモード
            SendMsg("*TRG")                                                         'トリガ
            SendQueryMsgBin(":MEASure?")                                            'バイナリ測定値の取得

            Array.Copy(MsgBufbin, 0, val1, 0, 4)                                    '測定値1
            Array.Copy(MsgBufbin, 4, val2, 0, 4)                                    '測定値2

            val1Single = ConvertBin2Single(val1)                                    '数値へ変換
            val2Single = ConvertBin2Single(val2)

            TextBox3.Text = BitConverter.ToString(MsgBufbin)
            TextBox4.Text = val1Single.ToString
            TextBox5.Text = val2Single.ToString

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try


        Try
            LanSocket.Close()                                                       'LANポートクローズ
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        Button1.Enabled = True

    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Dim SendBuffer As Byte()
        Try
            strMsg = strMsg & vbCrLf
            SendBuffer = System.Text.Encoding.Default.GetBytes(strMsg)
            LanSocket.GetStream.Write(SendBuffer, 0, SendBuffer.Length)             'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsgBin(ByVal strMsg As String)
         Try
            SendMsg(strMsg)
            Dim Check As Integer
            Dim Checkstr As String
            Dim digit As Integer
            Dim rcvsize As Integer = 0

            Check = ReadByteLan()                                                   '#の受信
            If Not Chr(Check) = "#" Then
                Exit Sub
            End If

            Check = ReadByteLan()                                                   '受信バイト桁数の受信
            Checkstr = Chr(Check)                                                   'キャラクターコードを文字に変換
            digit = Convert.ToInt32(Checkstr)                                       '文字を数値に変換

            For index = 1 To digit
                Check = ReadByteLan()                                               '受信バイト数の受信
                Checkstr = Chr(Check)                                               'キャラクターコードを文字に変換
                rcvsize += Convert.ToInt32(Checkstr) * Math.Pow(10, (index - 1))    '取得するバイナリサイズ
            Next

            MsgBufbin = Nothing
            ReDim MsgBufbin(rcvsize - 1)
            For index = 1 To rcvsize
                Check = ReadByteLan()
                MsgBufbin(index - 1) = BitConverter.GetBytes(Check)(0)              'データ受信
            Next

            Do                                                                      'ターミネータ受信
                Check = ReadByteLan()
                If Chr(Check) = vbLf Then
                    Exit Do
                End If
            Loop

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Function ReadByteLan() As Integer
        Dim Length As Integer
        Dim ReceiveBuffer(1) As Byte
        Do
            If LanSocket.GetStream.DataAvailable Then
                Length = LanSocket.GetStream.Read(ReceiveBuffer, 0, 1)              'LANデータ受信
                Exit Do
            End If
        Loop
        ReadByteLan = ReceiveBuffer(0)
    End Function

    Private Function ConvertBin2Single(ByVal val() As Byte) As Single
        Dim valSingle As Single

        Array.Reverse(val)                                                          'リトルエンディアンへ変換
        valSingle = BitConverter.ToSingle(val, 0)                                   'バイト列を変換

        ConvertBin2Single = valSingle
    End Function

End Class