﻿'*******************************************************************************
'このプログラムは、[測定]ボタンを押すと、バイナリ通信モードに変更し、
'トリガをかけて測定値を取得します。
'受信したバイナリデータをASCII文字列に変換します。
'*******************************************************************************

Public Class Form1
    Dim MsgBufbin() As Byte                                                         '受信バッファ（バイト型配列）

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim val1(3) As Byte
        Dim val1Single As Single
        Dim val2(3) As Byte
        Dim val2Single As Single

        Button1.Enabled = False

        Try
            'シリアルポートの設定
            SerialPort1.PortName = TextBox1.Text                                    'ポート名の設定
            SerialPort1.Open()                                                      'シリアルポートオープン

            SendMsg("*RST")                                                         'リセット
            SendMsg(":TRIGger EXTernal")                                            'トリガ：外部トリガ
            SendMsg(":FORMat:DATA REAL")                                            'データ転送モード：バイナリモード
            SendMsg("*TRG")                                                         'トリガ
            SendQueryMsgBin(":MEASure?")                                            'バイナリ測定値の取得

            Array.Copy(MsgBufbin, 0, val1, 0, 4)                                    '測定値1
            Array.Copy(MsgBufbin, 4, val2, 0, 4)                                    '測定値2

            val1Single = ConvertBin2Single(val1)                                    '数値へ変換
            val2Single = ConvertBin2Single(val2)

            TextBox2.Text = BitConverter.ToString(MsgBufbin)
            TextBox3.Text = val1Single.ToString
            TextBox4.Text = val2Single.ToString

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        If SerialPort1.IsOpen Then
            Try
                SerialPort1.Close()                                                 'シリアルポートクローズ
            Catch ex As Exception
                MsgBox(ex.Message)
            End Try
        End If

        Button1.Enabled = True

    End Sub

    Private Sub SendMsg(ByVal strMsg As String)
        Try
            strMsg = strMsg & vbCrLf
            SerialPort1.WriteLine(strMsg)                                           'メッセージ送信
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Sub SendQueryMsgBin(ByVal strMsg As String)
        Try
            SendMsg(strMsg)
            Dim Check As Integer
            Dim Checkstr As String
            Dim digit As Integer
            Dim rcvsize As Integer = 0

            Check = SerialPort1.ReadByte()                                          '#の受信
            If Not Chr(Check) = "#" Then
                Exit Sub
            End If

            Check = SerialPort1.ReadByte()                                          '受信バイト桁数の受信
            Checkstr = Chr(Check)                                                   'キャラクターコードを文字に変換
            digit = Convert.ToInt32(Checkstr)                                       '文字を数値に変換

            For index = 1 To digit
                Check = SerialPort1.ReadByte()                                      '受信バイト数の受信
                Checkstr = Chr(Check)                                               'キャラクターコードを文字に変換
                rcvsize += Convert.ToInt32(Checkstr) * Math.Pow(10, (index - 1))    '取得するバイナリサイズ
            Next

            MsgBufbin = Nothing
            ReDim MsgBufbin(rcvsize - 1)
            For index = 1 To rcvsize
                Check = SerialPort1.ReadByte()
                MsgBufbin(index - 1) = BitConverter.GetBytes(Check)(0)              'データ受信
            Next

            Do                                                                      'ターミネータ受信
                Check = SerialPort1.ReadByte()
                If Chr(Check) = vbLf Then
                    Exit Do
                End If
            Loop

        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try
    End Sub

    Private Function ConvertBin2Single(ByVal val() As Byte) As Single
        Dim valSingle As Single

        Array.Reverse(val)                                                          'リトルエンディアンへ変換
        valSingle = BitConverter.ToSingle(val, 0)                                   'バイト列を変換

        ConvertBin2Single = valSingle
    End Function

End Class