﻿Imports System
Imports System.IO
Imports System.IO.Ports

Public Class Form1

  'Perform process when Button1 is pressed
  Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
    Dim recvstr As String
    Dim i As Integer

    Try
      Button1.Enabled = False                   '  Disable buttons during communication  .............(a) 
      Button2.Enabled = False
      SerialPort1.NewLine = vbCrLf              '  Terminator setting  ...............................(b) 
      SerialPort1.ReadTimeout = 2000            '  2 seconds time out  ...............................(c) 
      SerialPort1.Open()                        '  Open a port
      SendSetting(SerialPort1)                  '  Instrument settings 
      FileOpen(1, "data.csv", OpenMode.Output)  '  Create text file to be saved  .....................(d) 

      For i = 1 To 10
        SerialPort1.WriteLine(":FETC?")         '  Begin measurement and read measurement results ....(e)
        recvstr = SerialPort1.ReadLine()        '  Read measurement results 
        PrintLine(1, recvstr)                   '  Write to file 
      Next i
    Catch ex As Exception
      MessageBox.Show(ex.Message, " Error ", MessageBoxButtons.OK, MessageBoxIcon.Error)
    End Try
    FileClose(1)                                '  Close file
    SerialPort1.Close()                         '  Close port 
    Button1.Enabled = True
    Button2.Enabled = True

  End Sub

  'Set measurement conditions 
  Private Sub SendSetting(ByVal sp As SerialPort)
    Try
      sp.WriteLine(":FUNC RV")        '  [R,X,V,T] function
      sp.WriteLine(":FREQ 1000")      '  Set frequency to 1000Hz
      sp.WriteLine(":TRIG:SOUR IMM")  '  Select internal triggering
      sp.WriteLine(":INIT:CONT ON")   '  Continuous measurement ON 
    Catch ex As Exception
      MessageBox.Show(ex.Message, " Error ", MessageBoxButtons.OK, MessageBoxIcon.Error)
    End Try
  End Sub

  'Close program when Button2 is pressed
  Private Sub Button2_Click(sender As Object, e As EventArgs) Handles Button2.Click
    Me.Dispose()
  End Sub

End Class

