﻿Imports System
Imports System.IO
Imports System.IO.Ports

Public Class Form1

  'Button1  を押された場合の処理を行う 
  Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
    Dim recvstr As String
    Dim i As Integer

    Try
      Button1.Enabled = False                   '  通信中はボタンを押せないようにする  ...........(a) 
      Button2.Enabled = False
      SerialPort1.NewLine = vbCrLf              '  ターミネータの設定  ...........................(b) 
      SerialPort1.ReadTimeout = 2000            '  タイムアウト２秒 ..............................(c) 
      SerialPort1.Open()                        '  ポートを開く
      SendSetting(SerialPort1)                  '  本体の設定 
      FileOpen(1, "data.csv", OpenMode.Output)  '  保存するテキストファイルを作成  ...............(d) 

      For i = 1 To 10
        SerialPort1.WriteLine(":FETC?")         '  最新の測定値取得  ":FETCH?"  を送信 ...........(e)
        recvstr = SerialPort1.ReadLine()        '  測定結果の読み込み 
        PrintLine(1, recvstr)                   '  ファイルへ書き出し 
      Next i
    Catch ex As Exception
      MessageBox.Show(ex.Message, "  エラー  ", MessageBoxButtons.OK, MessageBoxIcon.Error)
    End Try
    FileClose(1)                                '  ファイルを閉じる 
    SerialPort1.Close()                         '  ポートを閉じる 
    Button1.Enabled = True
    Button2.Enabled = True

  End Sub

  '  測定条件の設定を行う 
  Private Sub SendSetting(ByVal sp As SerialPort)
    Try
      sp.WriteLine(":FUNC RV")        '  [R,X,V,T]ファンクションに設定
      sp.WriteLine(":FREQ 1000")      '  測定周波数を1000Hzに設定
      sp.WriteLine(":TRIG:SOUR IMM")  '  内部トリガを選択 
      sp.WriteLine(":INIT:CONT ON")   '  連続測定を  ON 
    Catch ex As Exception
      MessageBox.Show(ex.Message, "  エラー  ", MessageBoxButtons.OK, MessageBoxIcon.Error)
    End Try
  End Sub

  'Button2  を押された時、プログラムを終了させる 
  Private Sub Button2_Click(sender As Object, e As EventArgs) Handles Button2.Click
    Me.Dispose()
  End Sub

End Class

